/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2;

import gen.core.project.RepositoryDefinition;
import gen.core.project.RepositoryMapping;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.team2.ProjectTeamSettings;
import org.omegat.core.team2.RemoteRepositoryFactory;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.StringUtil;

public class RemoteRepositoryProvider {
    public static final String REPO_SUBDIR = ".repositories/";
    public static final String REPO_PREPARE_SUBDIR = ".repositories/prep/";
    public static final String REPO_GIT_SUBDIR = ".git/";
    public static final String REPO_SVN_SUBDIR = ".svn/";
    final File projectRoot;
    final ProjectTeamSettings teamSettings;
    final List<RepositoryDefinition> repositoriesDefinitions;
    final List<IRemoteRepository2> repositories = new ArrayList<IRemoteRepository2>();

    public RemoteRepositoryProvider(File projectRoot, List<RepositoryDefinition> repositoriesDefinitions) throws Exception {
        this.projectRoot = projectRoot;
        this.teamSettings = new ProjectTeamSettings(new File(projectRoot, REPO_SUBDIR));
        this.repositoriesDefinitions = repositoriesDefinitions;
        this.checkDefinitions();
        this.initializeRepositories();
    }

    public ProjectTeamSettings getTeamSettings() {
        return this.teamSettings;
    }

    protected void checkDefinitions() {
        TreeSet<String> dirs = new TreeSet<String>();
        for (RepositoryDefinition r : this.repositoriesDefinitions) {
            if (StringUtil.isEmpty(r.getUrl())) {
                throw new RuntimeException("There is no repository url");
            }
            if (!dirs.add(this.getRepositoryDir(r).getAbsolutePath())) {
                throw new RuntimeException("Duplicate repository URL");
            }
            for (RepositoryMapping m : r.getMapping()) {
                if (m.getLocal() != null && m.getRepository() != null) continue;
                throw new RuntimeException("Wrong mapping");
            }
        }
    }

    protected void initializeRepositories() throws Exception {
        for (RepositoryDefinition r : this.repositoriesDefinitions) {
            IRemoteRepository2 repo = RemoteRepositoryFactory.create(r.getType());
            repo.init(r, this.getRepositoryDir(r), this.teamSettings);
            this.repositories.add(repo);
        }
    }

    protected List<Mapping> getMappings(String path, String ... forceExcludes) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        for (int i = 0; i < this.repositoriesDefinitions.size(); ++i) {
            RepositoryDefinition rd = this.repositoriesDefinitions.get(i);
            for (RepositoryMapping repoMapping : rd.getMapping()) {
                Mapping m = new Mapping(path, this.repositories.get(i), rd, repoMapping, forceExcludes);
                if (!m.matches()) continue;
                result.add(m);
            }
        }
        return result;
    }

    protected Mapping oneMapping(String path) {
        List<Mapping> mappings = this.getMappings(path, new String[0]);
        if (mappings.size() > 1) {
            throw new RuntimeException("Multiple mapping for file");
        }
        if (mappings.isEmpty()) {
            throw new RuntimeException("There is no mapping for file");
        }
        return mappings.get(0);
    }

    public boolean isUnderMapping(String path) {
        return !this.getMappings(path, new String[0]).isEmpty();
    }

    public void cleanPrepared() throws Exception {
        FileUtils.deleteDirectory(new File(this.projectRoot, REPO_PREPARE_SUBDIR));
    }

    public File toPrepared(File inFile) throws Exception {
        File dir = new File(this.projectRoot, REPO_PREPARE_SUBDIR);
        dir.mkdirs();
        File out = File.createTempFile("prepared", "", dir);
        FileUtils.copyFile(inFile, out);
        return out;
    }

    public void switchAllToLatest() throws Exception {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (IRemoteRepository2 r : this.repositories) {
            try {
                r.switchToVersion(null);
            }
            catch (IRemoteRepository2.NetworkException e) {
                throw e;
            }
            catch (Exception e) {
                errors.add(e);
                Log.logErrorRB("TEAM_UPDATE_REPO_ERROR", e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            throw (Exception)errors.get(0);
        }
    }

    public File switchToVersion(String filePath, String version) throws Exception {
        return this.oneMapping(filePath).switchToVersion(version);
    }

    public String commitFileAfterVersion(String path, String commentText, String ... onVersions) throws Exception {
        return this.oneMapping((String)path).repo.commit(onVersions, commentText);
    }

    public void commitFiles(String path, String commentText) throws Exception {
        TreeMap<String, IRemoteRepository2> repos = new TreeMap<String, IRemoteRepository2>();
        for (Mapping m : this.getMappings(path, new String[0])) {
            repos.put(m.repoDefinition.getUrl(), m.repo);
        }
        for (IRemoteRepository2 repo : repos.values()) {
            repo.commit(null, commentText);
        }
    }

    public void copyFilesFromRepoToProject(String localPath, String ... forceExcludes) throws Exception {
        for (Mapping m : this.getMappings(localPath, forceExcludes)) {
            m.copyFromRepoToProject();
        }
    }

    public void copyFilesFromProjectToRepo(String localPath, String eolConversionCharset) throws Exception {
        for (Mapping m : this.getMappings(localPath, new String[0])) {
            m.copyFromProjectToRepo(eolConversionCharset);
        }
    }

    public String getVersion(String file) throws Exception {
        return this.oneMapping(file).getVersion();
    }

    protected void copyFile(File from, File to, String eolConversionCharset) throws IOException {
        if (eolConversionCharset != null) {
            FileUtil.copyFileWithEolConversion(from, to, Charset.forName(eolConversionCharset));
        } else {
            FileUtils.copyFile(from, to);
        }
    }

    protected void addForCommit(IRemoteRepository2 repo, String path) throws Exception {
        repo.addForCommit(path);
    }

    protected File getRepositoryDir(RepositoryDefinition repo) {
        String path = repo.getUrl().replaceAll("[^A-Za-z0-9\\.]", "_").replaceAll("__+", "_");
        return new File(new File(this.projectRoot, REPO_SUBDIR), path);
    }

    static String withLeadingSlash(String s) {
        return s.startsWith("/") ? s : "/" + s;
    }

    static String withTrailingSlash(String s) {
        return s.endsWith("/") ? s : s + "/";
    }

    static String withoutLeadingSlash(String s) {
        return s.startsWith("/") ? s.substring(1) : s;
    }

    static String withoutTrailingSlash(String s) {
        return s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
    }

    static String withSlashes(String s) {
        return RemoteRepositoryProvider.withTrailingSlash(RemoteRepositoryProvider.withLeadingSlash(s));
    }

    static String withoutSlashes(String s) {
        return RemoteRepositoryProvider.withoutTrailingSlash(RemoteRepositoryProvider.withoutLeadingSlash(s));
    }

    class Mapping {
        final String filterPrefix;
        final IRemoteRepository2 repo;
        final RepositoryDefinition repoDefinition;
        final RepositoryMapping repoMapping;
        final List<String> forceExcludes;

        Mapping(String path, IRemoteRepository2 repo, RepositoryDefinition repoDefinition, RepositoryMapping repoMapping, String ... forceExcludes) {
            this.repo = repo;
            this.repoDefinition = repoDefinition;
            this.repoMapping = repoMapping;
            this.forceExcludes = new ArrayList<String>();
            path = RemoteRepositoryProvider.withSlashes(path);
            String local = RemoteRepositoryProvider.withSlashes(repoMapping.getLocal());
            if (path.equals("/")) {
                this.filterPrefix = "/";
                this.forceExcludes.addAll(Arrays.asList(forceExcludes));
            } else if (local.equals(path)) {
                this.filterPrefix = "/";
                this.forceExcludes.addAll(this.getTruncatedExclusions(local, forceExcludes));
            } else if (local.startsWith(path)) {
                this.filterPrefix = "/";
                this.forceExcludes.addAll(this.getTruncatedExclusions(local, forceExcludes));
            } else if (path.startsWith(local)) {
                this.filterPrefix = RemoteRepositoryProvider.withSlashes(path.substring(local.length()));
                this.forceExcludes.addAll(Arrays.asList(forceExcludes));
            } else if (local.equals("/")) {
                this.filterPrefix = path;
                this.forceExcludes.addAll(Arrays.asList(forceExcludes));
            } else {
                this.filterPrefix = null;
            }
        }

        List<String> getTruncatedExclusions(String prefix, String ... excludes) {
            String normalizedPrefix = RemoteRepositoryProvider.withSlashes(prefix);
            return Stream.of(excludes).map(RemoteRepositoryProvider::withLeadingSlash).filter(e -> e.startsWith(normalizedPrefix)).map(e -> RemoteRepositoryProvider.withLeadingSlash(e.substring(normalizedPrefix.length()))).collect(Collectors.toList());
        }

        public boolean matches() {
            return this.filterPrefix != null;
        }

        public void copyFromRepoToProject() throws Exception {
            if (!this.matches()) {
                throw new RuntimeException("Doesn't matched");
            }
            File from = new File(RemoteRepositoryProvider.this.getRepositoryDir(this.repoDefinition), RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getRepository()));
            File to = new File(RemoteRepositoryProvider.this.projectRoot, RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getLocal()));
            if (from.isDirectory()) {
                ArrayList<String> excludes = new ArrayList<String>(this.repoMapping.getExcludes());
                excludes.addAll(this.forceExcludes);
                this.copy(from, to, this.filterPrefix, this.repoMapping.getIncludes(), excludes, null);
            } else {
                if (!this.filterPrefix.equals("/")) {
                    throw new RuntimeException("Filter prefix should have been / for file mapping, but was " + this.filterPrefix);
                }
                RemoteRepositoryProvider.this.copyFile(from, to, null);
            }
        }

        public void copyFromProjectToRepo(String eolConversionCharset) throws Exception {
            if (!this.matches()) {
                throw new RuntimeException("Doesn't matched");
            }
            File from = new File(RemoteRepositoryProvider.this.projectRoot, RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getLocal()));
            File to = new File(RemoteRepositoryProvider.this.getRepositoryDir(this.repoDefinition), RemoteRepositoryProvider.withoutLeadingSlash(this.repoMapping.getRepository()));
            if (from.isDirectory()) {
                List<String> files = this.copy(from, to, this.filterPrefix, this.repoMapping.getIncludes(), this.repoMapping.getExcludes(), eolConversionCharset);
                for (String f : files) {
                    RemoteRepositoryProvider.this.addForCommit(this.repo, RemoteRepositoryProvider.withoutSlashes(f));
                }
            } else {
                if (!this.filterPrefix.equals("/")) {
                    throw new RuntimeException("Filter prefix should have been / for file mapping, but was " + this.filterPrefix);
                }
                RemoteRepositoryProvider.this.copyFile(from, to, eolConversionCharset);
                RemoteRepositoryProvider.this.addForCommit(this.repo, RemoteRepositoryProvider.withoutSlashes(this.repoMapping.getRepository()));
            }
        }

        public File switchToVersion(String version) throws Exception {
            this.repo.switchToVersion(version);
            File to = new File(RemoteRepositoryProvider.this.getRepositoryDir(this.repoDefinition), this.repoMapping.getRepository());
            return new File(to, this.filterPrefix);
        }

        public String getVersion() throws Exception {
            return this.repo.getFileVersion(new File(this.repoMapping.getRepository(), this.filterPrefix).getPath());
        }

        protected List<String> copy(File from, File to, String prefix, List<String> includes, List<String> excludes, String eolConversionCharset) throws Exception {
            prefix = RemoteRepositoryProvider.withSlashes(prefix);
            List<String> relativeFiles = FileUtil.buildRelativeFilesList(from, includes, excludes);
            ArrayList<String> copied = new ArrayList<String>();
            for (String rf : relativeFiles) {
                if ((rf = RemoteRepositoryProvider.withSlashes(rf)).startsWith("/.repositories/") || !prefix.isEmpty() && !prefix.equals("/") && !rf.startsWith(prefix)) continue;
                RemoteRepositoryProvider.this.copyFile(new File(from, rf), new File(to, rf), eolConversionCharset);
                copied.add(rf);
            }
            return copied;
        }
    }
}

