/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.dialogs.VersionCheckDialog;
import org.omegat.gui.main.IMainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.VersionChecker;

public final class VersionCheckThread
extends LongProcessThread {
    private static final Logger LOGGER = Logger.getLogger(VersionCheckThread.class.getName());
    private static final int CHECK_INTERVAL = 86400000;
    private final int initialDelaySeconds;
    private boolean enabled = true;

    public VersionCheckThread(int initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        this.enabled = Preferences.isPreferenceDefault("automatically_check_version", true);
        Preferences.addPropertyChangeListener("automatically_check_version", e -> {
            this.enabled = (Boolean)e.getNewValue();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            VersionCheckThread versionCheckThread = this;
            synchronized (versionCheckThread) {
                this.wait(this.initialDelaySeconds * 1000);
            }
            while (true) {
                versionCheckThread = this;
                synchronized (versionCheckThread) {
                    try {
                        if (this.enabled && !VersionChecker.getInstance().isUpToDate(false)) {
                            VersionCheckDialog dialog = new VersionCheckDialog(VersionChecker.getInstance().getRemoteVersion());
                            SwingUtilities.invokeAndWait(() -> dialog.show(this.getParentWindow()));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, OStrings.getString("VERSION_CHECK_FAILED", e));
                    }
                    this.wait(86400000L);
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Version check thread interrupted", e);
            return;
        }
    }

    private Window getParentWindow() {
        IMainWindow mw;
        Window window = FocusManager.getCurrentManager().getActiveWindow();
        if (window == null && (mw = Core.getMainWindow()) != null) {
            window = mw.getApplicationFrame();
        }
        return window;
    }
}

