/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.progress;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.loomchild.maligna.progress.ProgressMeter;
import net.loomchild.maligna.progress.ProgressObserver;

public class ProgressManager {
    private static ProgressManager instance = new ProgressManager();
    private Map<String, ProgressMeter> progressMeterMap = new HashMap<String, ProgressMeter>();
    private List<ProgressObserver> progressObserverList = new ArrayList<ProgressObserver>();

    public static ProgressManager getInstance() {
        return instance;
    }

    private ProgressManager() {
    }

    public ProgressMeter getProgressMeter(String name) {
        ProgressMeter progressMeter = this.progressMeterMap.get(name);
        if (progressMeter == null) {
            throw new IllegalArgumentException("Progress meter: " + name + " does not exist.");
        }
        return progressMeter;
    }

    public void registerProgressMeter(ProgressMeter progressMeter) {
        if (this.progressMeterMap.get(progressMeter.getName()) != null) {
            throw new IllegalArgumentException("Progress meter: " + progressMeter.getName() + " already exists.");
        }
        this.progressMeterMap.put(progressMeter.getName(), progressMeter);
        for (ProgressObserver progressObserver : this.progressObserverList) {
            progressObserver.registerProgressMeter(progressMeter);
        }
    }

    public void unregisterProgressMeter(ProgressMeter progressMeter) {
        if (this.progressMeterMap.remove(progressMeter.getName()) == null) {
            throw new IllegalArgumentException("Progress meter: " + progressMeter.getName() + " does not exist.");
        }
        for (ProgressObserver progressObserver : this.progressObserverList) {
            progressObserver.unregisterProgressMeter(progressMeter);
        }
    }

    void completeTask(ProgressMeter progressMeter) {
        for (ProgressObserver progressObserver : this.progressObserverList) {
            progressObserver.completeTask(progressMeter);
        }
    }

    public void registerProgressObserver(ProgressObserver progressObserver) {
        this.progressObserverList.add(progressObserver);
    }

    public void unregisterProgressObserver(ProgressObserver progressObserver) {
        if (!this.progressObserverList.remove(progressObserver)) {
            throw new IllegalArgumentException("Unknown observer " + progressObserver.toString());
        }
    }

    public List<ProgressObserver> getProgressObserverList() {
        return this.progressObserverList;
    }
}

