/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTableCursor;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;

public class SqlJetMapCursor
implements ISqlJetMapCursor {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private final SqlJetMapDef mapDef;
    private boolean writable;
    private ISqlJetMapTableCursor mapTable;
    private ISqlJetMapIndexCursor mapIndex;

    public SqlJetMapCursor(SqlJetMapDb mapDb, ISqlJetBtree btree, SqlJetMapDef mapDef, boolean writable) throws SqlJetException {
        if (!mapDb.isInTransaction()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Cursor requires active transaction");
        }
        this.mapDb = mapDb;
        this.btree = btree;
        this.mapDef = mapDef;
        this.writable = writable;
    }

    public synchronized ISqlJetMapTableCursor getMapTable() throws SqlJetException {
        if (this.mapTable == null) {
            this.mapTable = new SqlJetMapTableCursor(this.mapDb, this.btree, this.mapDef, this.writable);
        }
        return this.mapTable;
    }

    public synchronized ISqlJetMapIndexCursor getMapIndex() throws SqlJetException {
        if (this.mapIndex == null) {
            ISqlJetIndexDef indexDef = this.mapDef.getIndexDef();
            this.mapIndex = new SqlJetMapIndexCursor(this.mapDb, this.btree, indexDef, this.writable);
        }
        return this.mapIndex;
    }

    public synchronized void close() throws SqlJetException {
        if (this.mapTable != null) {
            this.mapTable.close();
            this.mapTable = null;
        }
        if (this.mapIndex != null) {
            this.mapIndex.close();
            this.mapIndex = null;
        }
    }

    public Object[] getKey() throws SqlJetException {
        return this.getMapIndex().getKey();
    }

    public Object[] getValue() throws SqlJetException {
        return this.getMapTable().getValue();
    }

    public boolean goToKey(Object[] key) throws SqlJetException {
        if (this.getMapIndex().goToKey(key)) {
            return this.getMapTable().goToKey(this.getMapIndex().getValue());
        }
        return false;
    }

    public void put(Object[] key, Object[] value) throws SqlJetException {
        this.getMapIndex().put(key, this.getMapTable().put(0L, value));
    }

    public boolean eof() throws SqlJetException {
        return this.getMapIndex().eof();
    }

    public boolean first() throws SqlJetException {
        return this.getMapIndex().first();
    }

    public boolean last() throws SqlJetException {
        return this.getMapIndex().last();
    }

    public boolean next() throws SqlJetException {
        return this.getMapIndex().next();
    }

    public boolean previous() throws SqlJetException {
        return this.getMapIndex().previous();
    }
}

