begin
  require 'gtk3'
rescue LoadError
  require 'gtk2'  
end


module Culter end
module Culter::Ensis

  class EnsisWindow < Gtk::Window
    def initialize(culter)
      super()
      @global_box = Gtk::VBox.new(false,0)
      self.add @global_box
      if self.respond_to? 'create_menu' then self.create_menu end
      @culter = culter
      self.create_all_components
    end
    
    def start
      self.show_all
      Gtk.main
    end
    
    def add_pane(name, box)
      box1 = Gtk::Frame.new(name)
      @global_box.add(box1)
      box1.add(box)
      return box1
    end    
  end
  
  # ------------------------------ Editor ------------------------

  class Editor < EnsisWindow
    def initialize(culter)
      super(culter)
      self.set_title('Segmentation Rules Editor' + (culter == nil ? '' : culter.name))
      self.signal_connect('destroy') { Gtk.main_quit }
      self.set_size_request(600,400)
    end
    def add_pane(name, box)
      box1 = Gtk::Frame.new(name)
      if box.is_a? Gtk::TreeView then
          @global_box.pack_start(box1,true,true)
          count = 0; box.model.each { |m,p,i| count = count + 1 }
          if count > 10 then
              sp = Gtk::ScrolledWindow.new
              sp.hscrollbar_policy = Gtk::PolicyType::NEVER
              sp.min_content_height = 100 if sp.respond_to? :min_content_height
              sp.add(box)
              box1.add(sp)
          else
              box1.add(box)
          end
      else
          @global_box.pack_start(box1,true,false)   # non-resizable
          box1.add(box)
      end
      return box1
    end    
    
    def create_menu
      menubar = Gtk::MenuBar.new
      @global_box.pack_start( menubar, false, false, 0)
      menu1 = Gtk::MenuItem.new('Test')
      menubar.append menu1
      item1 = Gtk::MenuItem.new 'Test'
      item1.signal_connect("activate") { open_test }
      item2 = Gtk::MenuItem.new 'Quit'      
      item2.signal_connect("activate") { Gtk.main_quit }
      menu = Gtk::Menu.new
      menu.append item1; menu.append item2
      menu1.set_submenu menu
    end
    def input_dialog(question)
        dialog = Gtk::MessageDialog.new(self, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT,
	     Gtk::MessageDialog::QUESTION,
             Gtk::MessageDialog::BUTTONS_OK_CANCEL,
             question)
        userEntry = Gtk::Entry.new
        userEntry.set_size_request(250,25)
        dialog.vbox.pack_end(userEntry, true, false, 0)
	dialog.show_all
	res = nil
	dialog.run do |response|
            if response == Gtk::Dialog::RESPONSE_OK
               res = userEntry.text
               dialog.destroy
	    else
               dialog.destroy
            end
	end
	return res
    end
  end
  
  class OptionsBox < Gtk::VBox
    def initialize(culter)
      super()
      self.add(@cascade = box('Cascade', culter, 'cascade'))
      self.add(formats = Gtk::HBox.new)
      formats.add(Gtk::Label.new('Format handles: '))
      formats.add(@fmtStart = box('Start',culter, 'formatHandle.start'))
      formats.add(@fmtEnd = box('End', culter,'formatHandle.end'))
      formats.add(@fmtIsolated = box('Isolated', culter,'formatHandle.isolated'))
    end
    
    def box(title, culter, field)
      box = Gtk::CheckButton.new(title)
      box.sensitive = false		# viewer, not editor. Don't know how to make it not editable but without graying it
      if field =~ /^(.+)\.(.+)/
          box.active = culter.send($1)[$2]
      else
          box.active = culter.send(field)
      end
      return box
    end
  end
  
  class RulesMappingBox < Gtk::TreeView
    def initialize(culter)
      super(@model = Gtk::ListStore.new(String,String))
      @langRules = culter.langRules
      renderer = Gtk::CellRendererText.new
      renderer.set_property 'yalign', 0		# align to top
      append_column Gtk::TreeViewColumn.new("Expression",renderer)
      columns[0].add_attribute renderer, "text", 0
      append_column Gtk::TreeViewColumn.new("Name",renderer)
      columns[1].add_attribute renderer, "text", 1
      @model.clear
      culter.defaultMapRule.each do |mr|
	row = @model.append
	row[0] = mr.pattern.to_s
	row[1] = mr.rulename
      end
      self.signal_connect('row-activated') { action_view }
      @selectedItem = nil; selection.signal_connect('changed') { |s| @selectedItem = s.selected }  
      self.expand_all    
    end
    def selectedItem() @selectedItem[1] end
  end
  
  class LangRuleViewDialog < Gtk::Dialog 
    def initialize(name,langRule)
      super(name, nil, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT,
             [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT])      
      vbox.add(@view = LangRuleView.new(langRule))
      signal_connect('response') { destroy }
    end
    def action!() show_all end
  end  
  
  class LangRuleView < Gtk::TreeView
    def initialize(langRule)
      super(@model = Gtk::ListStore.new(String,String,String,String,String))    
      renderer = Gtk::CellRendererText.new
      renderer.set_property 'yalign', 0		# align to top
      self.append_column Gtk::TreeViewColumn.new("Type",renderer)
      self.append_column Gtk::TreeViewColumn.new("Name",renderer)
      self.append_column Gtk::TreeViewColumn.new("Before",renderer)
      self.append_column Gtk::TreeViewColumn.new("After",renderer)
      self.columns[0].fixed_width = 100; self.columns[0].add_attribute renderer, "text", 0
      self.columns[1].fixed_width = 50; self.columns[1].add_attribute renderer, "text", 1      
      self.columns[2].fixed_width = 100; self.columns[2].add_attribute renderer, "text", 2      
      self.columns[3].fixed_width = 100; self.columns[2].add_attribute renderer, "text", 2      
      @model.clear; @params = Array.new
      langRule.each do |lr|
	row = @model.append
	if lr.is_a? Culter::CSC::ApplyRuleTemplate then
	  row[0] = 'Apply template'
	  row[1] = lr.ruleRef.name
	  row[2] = lr.ruleRef.rewriteRule.before
	  row[3] = lr.ruleRef.rewriteRule.after
	  @params.push lr.params
	else
	  if lr.break then row[0] = 'Break' else row[0] = 'Exception' end
	  if lr.ruleName =~ /[!:]/ then row[1] = '' else row[1] = lr.ruleName end
	  row[2] = lr.before ; row[3] = lr.after
	  @params.push nil
	end
      end
      self.signal_connect('row-activated') { action_view }
      @selectedItem = nil; selection.signal_connect('changed') { |s| @selectedItem = s.selected }  
    end
    def paramsForSelectedRule() @params[@selectedItem.to_s.to_i] end
    def currentRuleName() @selectedItem[1] end
  end  
  
  class ApplyTemplateListDialog < Gtk::Dialog 
    def initialize(name,list)
      super(name, nil, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT,
             [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT])    
      @view = Hash.new
      list.each do |paramName, values|
          vbox.add(@view[paramName] = ApplyTemplateListView.new(paramName, values))
      end
      signal_connect('response') { destroy }
    end
    def action!() show_all end
  end  
  
  class ApplyTemplateListView < Gtk::TreeView
    def initialize(name, list)
      super(@model = Gtk::ListStore.new(String))    
      renderer = Gtk::CellRendererText.new
      renderer.set_property 'yalign', 0		# align to top
      self.append_column Gtk::TreeViewColumn.new("Parameter '#{name}':",renderer)
      self.columns[0].add_attribute renderer, "text", 0
      @model.clear
      if list.is_a? String then item = list; list = Array.new; list.push item end
      list.each do |item|
	row = @model.append
	row[0] = item
      end
    end
  end  
  
  class TemplatesBox < Gtk::TreeView
    def initialize(culter)
      super(@model = Gtk::ListStore.new(String))
      renderer = Gtk::CellRendererText.new
      renderer.set_property 'yalign', 0		# align to top
      append_column Gtk::TreeViewColumn.new("Name",renderer)
      columns[0].add_attribute renderer, "text", 0
      @model.clear
      if culter.respond_to? 'ruleTemplates'
	 @map = culter.ruleTemplates
         culter.ruleTemplates.each do |name,rule| 
	   row = @model.append
	   row[0] = name
	 end
      else
	 @map = {}
      end
      self.signal_connect('row-activated') { action_view }
      @selectedItem = nil; selection.signal_connect('changed') { |s| @selectedItem = s.selected }  
      self.expand_all    
    end    
    def selectedItem() @selectedItem[0] end
  end
  
  class RuleViewDialog < Gtk::Dialog    
    def initialize(rule)
      super("Rule #{if rule.respond_to? 'name' then rule.name else 'View rule' end}", nil, Gtk::Dialog::MODAL | Gtk::Dialog::DESTROY_WITH_PARENT,
             [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_NONE])      
      vbox.add(panel1 = Gtk::HBox.new)
      panel1.add(@rbBreak = Gtk::RadioButton.new('Break'))
      panel1.add(@rbException = Gtk::RadioButton.new('Exception')) 
      @rbException.group = @rbBreak.group[0]
      @rbException.sensitive = @rbBreak.sensitive = false      
      vbox.add(panel2 = Gtk::HBox.new)
      panel2.add(Gtk::Label.new('Before: '))
      panel2.add(@beforeBox = Gtk::Entry.new)
      vbox.add(panel3 = Gtk::HBox.new)
      panel3.add(Gtk::Label.new('After: '))
      panel3.add(@afterBox = Gtk::Entry.new)
      @beforeBox.editable = @afterBox.editable = false
      @rule = rule
      if rule.respond_to? 'rewriteRule' then rule = rule.rewriteRule end
      if rule.break then @rbBreak.active = true else @rbException.active = true end 
      @beforeBox.text = rule.before; @afterBox.text = rule.after
      signal_connect('response') { destroy }
    end
    def action!() show_all end
  end  

  # ------------------------------ Tester ------------------------
  
  class Tester < EnsisWindow
    def initialize(culter)
      super(culter)
      self.set_title('Segmentation Rules Tester - ' + culter.name)
      self.set_default_size(300,500)
    end
  end
  
  class TextBox < Gtk::Frame
    def initialize(culter,resultBox)
      super()      
      self.add(textBox = Gtk::TextView.new)
      textBox.buffer.signal_connect('changed') { resultBox.setContents(DebugLine.cut_debug(culter, textBox.buffer.text)) } 
      textBox.wrap_mode = :word
    end
    
  end
  
  class ResultBox < Gtk::Frame
    def initialize
      super()
      @model = Gtk::ListStore.new(Integer, String,String)
      self.add(@view = Gtk::TreeView.new(@model))
      renderer = Gtk::CellRendererText.new
      renderer.set_property 'yalign', 0		# align to top      
      renderer.set_property 'wrap_mode',  :word
      renderer.set_property 'wrap_width',  250
      @view.append_column Gtk::TreeViewColumn.new("Number",renderer)
      @view.append_column Gtk::TreeViewColumn.new("Segment",renderer)
      @view.append_column Gtk::TreeViewColumn.new("Rules",renderer)
      @view.columns[0].fixed_width = 50; @view.columns[0].add_attribute renderer, "text", 0
      @view.columns[1].fixed_width = 250; @view.columns[1].sizing = Gtk::TreeViewColumn::FIXED; @view.columns[1].add_attribute renderer, "text", 1      
      @view.columns[2].fixed_width = 100; @view.columns[2].add_attribute renderer, "text", 2      
    end
    
    def setContents(split)
      @model.clear
      i = 0
      split.each do |segment|
	row = @model.append
	i = i + 1; row[0] = i
	row[1] = segment.phrase_with_mark("\u2316")
	row[2] = segment.rules.join("\r\n")	
      end
      @view.expand_all
    end    
  end


  
end

