=head1 MODE by_code::theme

In this mode, 3 themes are defined : agriculture, transport and technology. Each memory inherits from one of these themes. Each theme can contain up to 1 billion memories.

You can change the list of themes by looking in the code and changing C<@THEMES> array. But do it I<before> any table creation.

=cut
package by_code::theme::TableCreator;

use parent by_code::TableCreator;

our @THEMES = ('Agriculture', 'Transport', 'Technology');

sub loadTables {
	shift->SUPER::loadTables(@_);
	# Also declare one table per theme: all inherit from public.memx
	foreach my $theme (@THEMES) { 
		$TableCreator::reqStr{TABLE}{"public.\L$theme"} = "create table public.\L$theme () inherits(public.memx)"; 
	}
}

sub memCode {
	my ($self, $parent, $table) = @_; 
	$parent = "public.$parent" unless $parent =~ /\./; $table = "public.$table" unless $table =~ /\./;
	for (my $i = 0; $i < @THEMES; $i++) {
		if (lc($parent) eq lc("public.$THEMES[$i]")) {
			my ($seq) = $self->{dbh}->selectrow_array("select nextval('seq_$THEMES[$i]')");
			unless ($seq) {
				$self->{dbh}->do ("create sequence seq_$THEMES[$i]");
				($seq) = $self->{dbh}->selectrow_array("select nextval('seq_$THEMES[$i]')");
			}
			return $i * 1E9 + $seq;
		} elsif (lc($table) eq lc("public.$THEMES[$i]")) {
			return $i * 1E9;
		}
	}
	die "Could not find which parent to use: $parent is not in the list";
}

sub checkId_sql { 
	my ($self, $table,%args) = @_;
   for (my $i = 0; $i < @THEMES; $i++) {
     	if ($table =~ /(\W)$THEMES[$i]$/i) { 
          my $a = $i * 1E9; my $b = $a + 1E9;
          return "mem_code bigint not null default 0 check(mem_code >= $a and mem_code < $b)"; 
       }
   }
	return $self->SUPER::checkId_sql($table,%args);
}

1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
