-- DESCRIPTION
-- 	This is the base tables for Cyclotis database
--	This file contains only the variants for by_id::withRules mode.
--	Other tables may be copies (example : create table table2 (like mem))
--	or derivatives (example: create table mem2() inherits (mem))

-- Base table
CREATE TABLE tra (
	mem_id integer not null,	-- identifies the current table, references meta_info(mem_id): identical in each row (NOT a primary key!)
	-- tool_info text,		-- optional field
    src text,
    tra text
);

-- Memory where segments with same source are differentiated by context
--	context is a semi-identifier: the pair (src,context) must be unique, ensured by a rule (on new insertion, do instead replace)
--		the value can be anything you want, provided that you are sure the "=" operator works correctly.
--	 	we do not set "constraint memx_ctx unique (src,context)" because
--		1. constraints are not inherited, and you will probably use an inherited table instead of memx itself
--		2. the constraint is not true for versionned tables.
CREATE TABLE memid (
     context text null
)
    inherits (memx);	-- no multiple inheritance so we build a single tree
	
CREATE TYPE std_Parent_name as ENUM ('glos','mem','memup','memx','memid');

CREATE TABLE meta_info (	
	mem_id serial not null primary key,
	table_schema name not null,	-- sql schema name (varchar(63) unless other config when built postmaster)
	table_name name not null,	-- sql table name (varchar(63) unless other config when built postmaster)
	std_parent std_Parent_name not null,        -- one of the standard parents
	children int[] null,		-- references other mem_id instances
	src_lang varchar(20),
	tra_lang varchar(20)
);

CREATE TABLE log_queries(
	date timestamp not null default now(),
	user int not null references users(id),
	memory int not null references meta_info(mem_id),
	query text not null, 
	method text not null,
	duration real not null
);
	
-- LICENCE
--
--  Copyright 2014-2015 Silvestris Project (http://www.silvestris-lab.org/)
--
--  Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
--  You may not use this work except in compliance with the Licence.
--  You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl
--
--  Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the Licence for the specific language governing permissions and limitations under the Licence. 
