package TableCreator;

our %reqStr, %realTypes; 

sub loadTables {
	my $self = shift; my $dir = shift || substr($INC{TableCreator.pm}, 0, rindex($INC{TableCreator.pm},'/'));
	if (open(SQL, "< $dir/tables.sql")) {
	   local $/ = ';';
	   while (<SQL>) {
		  s/^\s+//s; 1 while s/^\-\-.+?\n//g;
		  $reqStr{uc($1)}{lc($2 || 'public.') . lc($3)} = $_ if /CREATE(?:\s+OR\s+REPLACE)?\s+(\w+)\s+(\w+\.)?(\w+)/i;
	   }
	   close (SQL);
	   # If tables are already created, pre-load their column types
	   if (my $dbh = $self->{dbh} || shift) {
		   my $sth_info = $dbh->prepare_cached ("select column_name, udt_name,character_maximum_length from INFORMATION_SCHEMA.COLUMNS where table_name = ? and table_catalog = ? and table_schema = ?");
		   my ($dbname) = &DbCreator::analyse_dbSpec($dbParam);	# array, first element contains the name
		   foreach my $table (keys (%{$reqStr{TABLE}})) {
			  $sth_info->execute (substr($table,7), $dbname, 'public'); 
			  while (my ($col,$type,$len) = $sth_info->fetchrow_array) { 
				 $realTypes{$col} = $type; $realTypes{$col} .= "($len)" if $type =~ /char/i;
			  }
		   }
	   }
	   if (%realTypes) { print STDERR "Database already contains tables.\n"; }
	   if ($realTypes{props}) { print STDERR "In database, PROPS = ", ($ENV{CYCLOTIS_PROPS_TYPE} = $realTypes{props}), "\n"; } else { print STDERR "From environment, PROPS = ", ($ENV{CYCLOTIS_PROPS_TYPE} ||= 'text'), "\n"; }
	   if ($realTypes{context}) { print STDERR "In database, CONTEXT = ", ($ENV{CYCLOTIS_CONTEXT_TYPE} = $realTypes{context}), "\n"; } else { print STDERR "From environment, CONTEXT = ", ($ENV{CYCLOTIS_CONTEXT_TYPE} ||= 'text'), "\n"; }
	   if ($realTypes{tool_info}) { print STDERR "In database, TOOL_INFO = ", ($ENV{CYCLOTIS_TOOL_INFO_TYPE} = $realTypes{tool_info}), "\n"; } else { print STDERR "From environment, TOOL_INFO = ", ($ENV{CYCLOTIS_TOOL_INFO_TYPE} ||= ''), "\n"; }
	   if ($realTypes{src} =~ /\(\s*(\d+)\s*\)/) { print STDERR "In database, text length = ", ($ENV{CYCLOTIS_TEXT_LEN} = $1), "\n"; }
	   # Now, make corrections in %reqStr
	   foreach (values (%{$reqStr{TABLE}})) {
		  s/\bTEXT\b/varchar($ENV{CYCLOTIS_TEXT_LEN})/i if $ENV{CYCLOTIS_TEXT_LEN}; # admin requested to restrict column sizes.
		  s/props\s+(.+)\s+null/props $ENV{CYCLOTIS_PROPS_TYPE} null/i if $ENV{CYCLOTIS_PROPS_TYPE};
		  s/context\s+(.+)\s+null/context $ENV{CYCLOTIS_CONTEXT_TYPE} null/i if $ENV{CYCLOTIS_CONTEXT_TYPE};					
		  s/TABLE\s+(\w+)([^\.\w])/TABLE public.$1$2/; # better recognition in later subs
		  s/\-\-\s*tool_info.+\n/tool_info $ENV{CYCLOTIS_TOOL_INFO_TYPE},\n/ if $ENV{CYCLOTIS_TOOL_INFO_TYPE};
	   }
	} else {
		die "Cannot load tables.sql from $dir";
	}
}

use DbCreator;

sub doCreate_table {
   my $self = shift; my $dbh = $self->{dbh};
   my $table = shift || die "$0 $command : Missing table name\nSyntax: $0 $command <db name> <table name> <parent>? <props=type>? <context=type>?"; my $parent = shift || 'MEM';
   if ($parent =~ /=/) { unshift(@_, $parent); $parent = 'MEM'; }
   my $owner = undef, $props = undef, $context = undef, $toolInfo = undef; my @with; my @readers; my @writers;
   foreach (@_) {
		print "ARG $_\n";
		$props = $1 if /prop(?:ertie)?s=(.+)/;  $context = $1 if /c(?:on)?te?xt?=(.+)/; $toolInfo = $1 if /(?:tool_?)?info?=(.+)/;
		$owner = $1 if /owner=(.+)/i;
		push(@with, $1) if /^\-?\-?with-(\w+)$/;
		@readers = split(/,/, $1) if /pgreaders=(.+)$/; push(@readers, split(/,/, $main::ENV{CY_DB_READERS})) if $main::ENV{CY_DB_READERS};
		@writers = split(/,/, $1) if /pgwriters=(.+)$/; push(@writers, split(/,/, $main::ENV{CY_DB_WRITERS})) if $main::ENV{CY_DB_WRITERS};
   }
   $parent = $self->replacedTableName ($parent, 'type:props' => $props, 'type:context' => $context, 'type:tool_info' => $toolInfo);
   my %meta = $self->create_meta_info (lc($table), lc($parent), @_);	# call create_meta_info before, and use the result
   eval { $self->recursive_create_table ($table, parent => $parent, with => \@with, owner => $owner, readers => \@readers, writers => \@writers, %meta); };
   if ($@) { $self->cancel_all (%meta); die $@; }
   $self->createIdRules ($table, %meta);	
   foreach (@_) {
		if (/rule=(\w+),([\w\-]+)(:\w+(?:\w+)?)?/) {
			my ($field,$action,$tableRead) = ($1,$2,$3);
			&DbCreator::doCreate_rule($table . $tableRead, $field,$action);
		} elsif (/index=(\w+)(:\w+)?/) {
			my ($type,$lang) = ($1,$2);
			$lang ||= $src_lang if $type =~ /src/i; $lang ||= $tra_lang if $type =~ /tra/i;
			&DbCreator::doCreate_index($table, $type, $lang);
		}
   }
   $self->update_meta_info (lc($table), lc($parent), @_);
}


sub updateParentTables {}	# default, may be overridden

# Creates a table and eventually the parents
sub recursive_create_table {
    my ($self, $table, %args) = @_; my $parent = lc($args{parent});
    print STDERR "recursive_create_table($table) ",  $parent ? "inherits ($parent)" : "", "\n";
	die "Forbidden inherit combination: $parent for mode " . (ref($self) || $self) unless $parent !~ /,/ or $self->can_inherit(split (/,/, $parent));
    return unless $table;
    
    $table = "public.$table" unless $table =~ /\./; # else, may not be found in %reqStr
	my $req = $reqStr{TABLE}{lc($table)};
	unless ($req) { 	# Personal table
		die "Cannot create personal table $table without parent" unless $parent;
		my $checkId_sql = $self->checkId_sql($table, %args);
		$req = "create table $table ($checkId_sql) inherits ($parent)"; 
	} else {	# Standard table
		if ($args{with}) {	# optional columns
			foreach my $col (@{$args{with}}) {
				$req =~ s!\-\-\s*,?\s*($col.+?\n)!$1!;
			}
		}
		$req =~ s!\-\-.*?\n!!; # drop SQL comments	
	}
    print STDERR $req, "\n";
	
    unless ($self->{dbh}->do($req)) {
		if ($self->{dbh}->state eq '42P07') { # Already existing table
			my @caller = caller(1);
			if ($caller[3] =~ /recursive_create_table/) { return $table; } else { die $DBI::errstr; }
		}
		elsif (($self->{dbh}->state eq '42704') and ($DBI::errstr =~ /\btype\b/)) {
			my ($typeName) = ($DBI::errstr =~ /"(.+?)"/); $typeName = lc($typeName);
			if ($typeName =~ /hstore/) { &DbCreator::createExtension ($self->{dbiSpec}, 'hstore'); }
			elsif (my $req = ($reqStr{TYPE}{$typeName} || $reqStr{TYPE}{"public.$typeName"})) { $self->{dbh}->do($req) or die $DBI::errstr; }
			else { die $DBI::errstr; }	# this type is not known at all
		}
		elsif ($self->{dbh}->state eq '42P01') { 	# an inherited table does note exist
			print STDERR "One or more parent(s) do(es) not exist, try to create it\n";
			my @parents = split(/,/, $1) if $req =~ /inherits\s*\((.+?)\)/;
			for (my $i = 0; $i < @parents; $i++) {
				eval {  
					$parents[$i] = $self->recursive_create_table ($parents[$i], %args, parent => undef); # do NOT specify parent here
				};
				die $@ if $@ and $self->{dbh}->state ne '42P07';
			}
		}
		elsif ($self->{dbh}->state !~ /^0/) { die $DBI::errstr; }	# other error		
		$self->recursive_create_table ($table, %args) or die $DBI::errstr;
	} else {
		print STDERR "Create table ($table) OK\n";
		if ($args{owner} and not $reqStr{TABLE}{lc($table)}) {
			if ($self->{dbh}->do ("ALTER TABLE $table OWNER TO \"$args{owner}\"")) {
				print STDERR "Affectation to user $owner OK\n";				
			} else {
				print STDERR "ERROR: could not change owner ($DBI::errstr)\n";				
			}
		}		
		return $table;
	}
	if ($TableCreator::reqStr{TABLE}{lc($table)}) {	# is a standard table
		$self->{dbh}->do("grant select on $table to public");	# else, it may not appear at all during searches
	} else {
		foreach my $user (@{$args{writers}}) {
			DbCreator::grant ('select,update,insert,delete', $user, "TABLE $table", $self->{dbh});
		}
		foreach my $user (@{$args{readers}}) {
			DbCreator::grant ('select', $user, "TABLE $table", $self->{dbh});
		}
	}
	$self->updateParentTables ($parent, %args);
	return $table;
}

# if type:props or type:context is defined, create a table query whose name contains suffixes.
sub replacedTableName {
	my ($self, $tableName, %types) = @_;
	# 0. Recursive calls
	if (wantarray) {
		return map { $self->replacedTableName($_,%types) } @$tableName if ref($tableName);
		return map { $self->replacedTableName($_,%types) } split(/,/,$tableName) if $tableName =~ /,/;
	} else {
		return join(',', map { $self->replacedTableName($_,%types) } @$tableName) if ref($tableName);
		return join(',', map { $self->replacedTableName($_,%types) } split(/,/,$tableName)) if $tableName =~ /,/;	
	}
	# 1. builds name of the new table: adds suffixes
	$tableName = "public.$tableName" unless $tableName =~ /\./; $tableName = lc($tableName); # else, may not be found in %reqStr
	my $newTable = $tableName; $newTable =~ s/_[a-z0-9]+$//; $newTable .= '_'; my $cpt = 0;
	foreach my $col ('props','context') { 
		next unless has_column($tableName, $col);
		my $type = lc($types{'type:' .$col} || $ENV{"CYCLOTIS_\U${col}_TYPE"}); $cpt++ if $type ne lc($realTypes{$col} || $ENV{"CYCLOTIS_\U${col}_TYPE"} || 'text');
		$newTable .= substr($type,0,1); $newTable .= $1 if $type =~ /(\d+)/; 
	}
	if ($types{'type:tool_info'} and ($types{'type:tool_info'} ne ($realTypes{tool_info} || $ENV{CYCLOTIS_TOOL_INFO_TYPE}))) {
		$newTable .= substr($types{'type:tool_info'},0,1); $newTable .= $1 if $types{'type:tool_info'} =~ /(\d+)/; $cpt++;
	}
	return $tableName if (!$cpt) or ($newTable eq $tableName) or ($newTable eq $tableName . '_');
	print STDERR "Replacing $tableName by $newTable\n";
	# 2. creates a query for the new table : takes original query and replaces names or types
	$reqStr{TABLE}{$newTable} = $reqStr{TABLE}{$tableName};
	$reqStr{TABLE}{$newTable} =~ s/TABLE $tableName/TABLE $newTable/i;
	if ($types{'type:tool_info'} and ($types{'type:tool_info'} ne ($realTypes{tool_info} || $ENV{CYCLOTIS_TOOL_INFO_TYPE}))) {
		if (lc($types{'type:tool_info'}) eq 'null') { $reqStr{TABLE}{$newTable} =~ s/(\-\-)?\s*tool_info.+\n//; }
		else { $reqStr{TABLE}{$newTable} =~ s/(\-\-)?\s*tool_info.+\n/tool_info $types{'type:tool_info'},\n/;  }
	}
	foreach my $col ('props','context') { my $typ = $types{"type:$col"} ||= $types{$col} || $ENV{"CYCLOTIS_\U${col}_TYPE"} || 'text'; $reqStr{TABLE}{$newTable} =~ s/$col\s+(.+)\s+null/$col $typ null/; }
	my $parent = $1 if $reqStr{TABLE}{$tableName} =~ /inherits\s*\((.+?)\)/; $parent =~ s/\s//g; my @inherit = split(/,/, $parent); 
	for (my $i = 0; $i < @inherit; $i++) {
		$inherit[$i] = $self->replacedTableName($inherit[$i], %types);
	}
	$parent = join(',', @inherit); $reqStr{TABLE}{$newTable} =~ s/inherits\s*\((.+?)\)/inherits ($parent)/;
	return $newTable;
}

sub has_column {
	my $tableName = shift; my $col = shift;
	return 1 if $reqStr{TABLE}{$tableName} =~ /$col/i;
	my $parentStr = $1 if $reqStr{TABLE}{$tableName} =~ /inherits\s*\((.+?)\)/; $parentStr =~ s/\s//g; my @inherit = split(/,/, $parentStr); 
	foreach my $parentTable (@inherit) { return 1 if has_column($parentTable, $col); }
	return 0;
}

1;

=head1 License

Copyright 2013-2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
