=head1 MODE by_id::withRules

Tables contain an integer as discriminant. All lines contain this value, so it takes more space on disk. 

This mode is ideal if you use the REST server, with a lot of tables: thanks to the id, the server can minimize the number of different SQL queries it has in RAM.
Inheritance with personal tables is supported but implies lot of work at database side, so it is not ideal.
Note that you must use Postgresql 9.2 or later to use this.

=cut
package by_id::withRules::TableCreator;

use parent TableCreator;

sub loadTables {
 	my ($self, $dir, $dbh) = @_;
	$self->SUPER::loadTables ($dir ? "$dir/by_id/withRules" : substr($INC{'by_id/withRules/TableCreator.pm'}, 0, rindex($INC{'by_id/withRules/TableCreator.pm'},'/')), $dbh || $self->{dbh});
	$self->SUPER::loadTables ($dir || substr($INC{'TableCreator.pm'}, 0, rindex($INC{'TableCreator.pm'},'/')), $dbh || $self->{dbh});
}

# by_id mode supports single inheritance
sub can_inherit { scalar(@_) == 2 }	

sub create_meta_info {
 	my $self = shift; my $dbh = $self->{dbh};
 	my $table = shift; my $parent = shift || 'MEM';
 	my $src_lang = undef, $tra_lang = undef;
 	foreach (@_) {
		print "ARG $_\n";
		$src_lang = $1 if /src\P{Letter}?(?:La?n?g?)?=(.+)/i; $tra_lang = $1 if /tra\P{Letter}?(?:La?n?g?)?=(.+)/i;	# supports syntax: srcLang, src_lang, src, srcLng, ...
 	}   
	my $stdParent = lc($parent); $stdParent = "public.$stdParent" unless $stdParent =~ /\./;
	unless ($TableCreator::reqStr{TABLE}{$stdParent}) {	# Search for the 1st parent which is standard
		my $st_find_Parent = $dbh->prepare('select std_parent from meta_info where table_schema=? and table_name=?');
		my ($stdSchema); if ($stdParent =~ /^(.+)\.(.+)$/) { ($stdSchema, $stdParent) = ($1, $2); } else { $stdSchema = 'public'; }
		if ($st_find_Parent->execute ($stdSchema, $stdParent)) {
			if (my @row = $st_find_Parent->fetchrow_array) { $stdParent = $row[0]; }
			else { die "Could not find table $parent in meta_info, cannot create a child table from it"; }
		}
		else { die "Problem while exploring meta_info : $DBI::errstr"; }
	}
	$stdParent =~ s/^(\w+\.)//; print STDERR "Parent = $parent, standard parent = $stdParent\n";
	my ($schema, $table1) = split(/\./,$table); unless ($table1) { ($schema,$table1) = ('public',$table); }
	my $meta = $dbh->prepare ('insert into meta_info (table_schema, table_name, std_parent, src_lang, tra_lang) values (?,?,?,?,?)');
	unless ($meta->execute (lc($schema), lc($table1), lc($stdParent), lc($src_lang) || '', lc($tra_lang) || '')) {
		$self->recursive_create_table ('public.meta_info');
		$meta->execute (lc($schema), lc($table1), lc($stdParent), lc($src_lang) || '', lc($tra_lang) || '');
	}
	my $mem_id = $dbh->last_insert_id(undef, 'public', 'meta_info', 'mem_id');
	print STDERR "last_insert_id(undef, 'public', 'meta_info', 'mem_id') = $mem_id\n";
	# Result for next steps
	return (mem_id => $mem_id, stdParent => $stdParent);
}

sub update_meta_info {} # Nothing to update
sub cancel_all {
  my ($self, %meta) = @_;
  $self->{dbh}->do ("delete from public.meta_info where mem_id = $meta{mem_id}");
}

sub checkId_sql { my (undef,undef,%args) = @_; "mem_id integer not null default $args{mem_id} check(mem_id=$args{mem_id})" }
 
sub createIdRules {
	my ($self, $table, %args) = @_;
	print STDERR "createIdRules $table $args{mem_id} $args{stdParent}\n";
	if ($args{mem_id} && $args{stdParent} && ($args{stdParent} ne $table)) {
		my $table1 = $table; $table1 =~ s/\./_/;
		$self->{dbh}->do("create rule r_$table1 as 
					          on insert to $args{stdParent} where mem_id=$args{mem_id}
					          do instead insert into $table values (new.*)")
			or die $DBI::errstr;
	}
}

sub updateParentTables {
	my ($self, $parent, %args) = @_;
	print STDERR "updateParentTables $parent $args{mem_id} $args{stdParent}\n";
	my @parents = ref ($parent) ? @$parent : split(/,/, $parent);
	my $st_constraint = $self->{dbh}->prepare_cached(
			"SELECT conname, pg_catalog.pg_get_constraintdef(r.oid, true) as condef 
			   FROM pg_catalog.pg_constraint r 
			  WHERE r.conrelId = ?::regclass and conname like ?");
	my $st_parent = $self->{dbh}->prepare_cached ("SELECT pg_namespace.nspname || '.' || pg_class.relname
      FROM pg_catalog.pg_inherits
        INNER JOIN pg_catalog.pg_class ON (pg_inherits.inhparent = pg_class.oid)
          INNER JOIN pg_catalog.pg_namespace ON (pg_class.relnamespace = pg_namespace.oid)
          WHERE inhrelid = ?::regclass");
	my $st_meta_info = $self->{dbh}->prepare_cached('update meta_info set children=children || ?::int where table_schema = ? and table_name = ?');
	foreach my $parent0 (@parents) {
		$parent0 = lc($parent0); $parent0 = "public.$parent0" unless $parent0 =~ /\./;
		unless ($TableCreator::reqStr{TABLE}{$parent0}) {
			$st_constraint->execute ($parent0, substr($parent0,index($parent0,'.') + 1) . '_mem_id_check'); my ($constraint, $def) = $st_constraint->fetchrow_array();
			if ($constraint) {
				$self->{dbh}->do ("alter table $parent drop constraint $constraint");
				my @vals = split(/,/, $1) if $def =~ /[\(\[]([\d\,\s]+)[\]\)]/; @vals = ($1) if $def =~ /=\s*(\d+)/;
				$self->{dbh}->do (sprintf("alter table $parent add constraint $constraint check (mem_id in (%s))", join(',', @vals, $args{mem_id})));				
				$st_meta_info->execute ($args{mem_id}, split(/\./, $parent0));;
			}
			$st_parent->execute ($parent0);
			while (my @t = $st_parent->fetchrow_array) { $self->updateParentTables ($t[0], %args); }
		}
	}
}
 
sub replacedTableName {
	my ($self, $tableName, %types) = @_;
	my $replace = $self->SUPER::replacedTableName($tableName, %types);
	unless ($tableName eq $replace) {
		my $part = $replace; $part =~ s/^public\.//g;
		$self->{dbh}->do ("alter type public.std_Parent_name add value '$part'");		
	}
	return $replace;
}
 
1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
