=head1 MODE by_code::lang

In this mode, the tree is built upon source and target language : 
any new table inherits from MEM_%SRC_%TRA where %SRC and %TRA are replaced by source and target language.

Limited to 5 languages and 1 billion tables per language pair, but you can easily change this inside the code (remember that this mode is only an example).

Note : this mode will die if you did not specify source or target language.

=cut
package by_code::lang::TableCreator;

use parent by_code::TableCreator;

our @LANGS = ('eo', 'fr', 'en', 'de','ru');

sub loadTables {
	shift->SUPER::loadTables(@_);
	# Also declare one table per lang pair: all inherit from public.memx
	foreach my $src (@LANGS) {
		foreach my $tra (@LANGS) {	
			$TableCreator::reqStr{TABLE}{"public.\L${src}_${tra}"} = "create table public.\L${src}_${tra} () inherits(public.memx)"; 
		}
	}
}

sub memCode {
	my ($self, $parent, $table, $srcLang, $traLang) = @_; 
	die "In mode by_code::lang, source and target language are always required" unless $srcLang and $traLang;
	$parent = "public.MEMX_${srcLang}_${traLang}"; $table = "public.$table" unless $table =~ /\./;
	my $mem_code = -1;
	for (my $i = 0; $i < @LANGS; $i++) { $mem_code = $i * 1E10 if $LANGS[$i] eq $srcLang; }
	die "Undefined language $srcLang : you must use one of " . join(',',@LANGS) unless $mem_code >= 0;
	for (my $i = 0; $i < @LANGS; $i++) { $mem_code += $i * 1E9 if $LANGS[$i] eq $traLang; }
	
	my ($seq) = $self->{dbh}->selectrow_array("select nextval('seq_$srcLang_$traLang')");
	print STDERR "Nextval(seq_$srcLang_$traLang) = $seq\n";
	unless ($seq) {
		$self->{dbh}->do ("create sequence seq_$srcLang_$traLang");
		($seq) = $self->{dbh}->selectrow_array("select nextval('seq_$THEMES[$i]')");
	}
	return $mem_code + $seq;
}

sub checkId_sql { 
	my ($self, $table,%args) = @_;
	my $langRegex = join('|', @LANGS);
	if ($table =~ /^(?:public\.)?MEMX_($langRegex)_($langRegex)/i) {
		my $mem_code = -1;
		for (my $i = 0; $i < @LANGS; $i++) { $mem_code = $i * 1E10 if $LANGS[$i] eq $srcLang; }
		for (my $i = 0; $i < @LANGS; $i++) { $mem_code += $i * 1E9 if $LANGS[$i] eq $traLang; }
		my $code_end = $mem_code + 1E9;
		return "mem_code bigint not null default 0 check(mem_code >= $mem_code and mem_code < $code_end)"; 
	}
	return $self->SUPER::checkId_sql($table,%args);
}

1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
