=head1 MODE by_path

Tables contain a string as discriminant. All lines contain this value, so it takes more space on disk. 

This mode is ideal if you use the REST server, with a frequent use of personal table inheritance: 
when querying a parent table, the path is used to make the distinction between entries coming from different children,
even if you call it from the REST service.

Note that you must use Postgresql 9.2 or later to use this.

=cut
package by_path::TableCreator;

use parent TableCreator;

# by_path mode supports single inheritance
sub can_inherit { scalar(@_) == 2 }	

# path, given parameters
sub memPath {
	my ($self, $parent, $table) = @_;  $table = "public.$table" unless $table =~ /\./;
	my $mem_path = join($self->pathSeparator(), $parent, $table); $mem_path =~ s/^public\.//;
	unless ($parent =~ /^(public\.)?(tra|mem|glos)/i) {
		my ($s,$t); if ($parent =~ /\./) { ($s, $t) = map { lc($_) } split(/\./, $parent); } else { ($s, $t) = ('public', $parent); } 
		my ($path) = $self->{dbh}->selectrow_array("select mem_path from public.meta_view where table_schema='$s' and table_name='$t'");
		if ($self->{dbh}->state eq '42P01') {
			$self->{dbh}->do($TableCreator::reqStr{VIEW}{'public.meta_view'});
      if ($self->{dbh}->state eq '42P01') { $self->recursive_create_table ('public.meta_info'); $self->{dbh}->do($TableCreator::reqStr{VIEW}{'public.meta_view'}); }
			($path) = $self->{dbh}->selectrow_array("select mem_path from public.meta_view where table_schema='$s' and table_name='$t'");
		}
		die "Table $parent is not declared. Exit.\n" unless $path;
		$mem_path = join($self->pathSeparator(), $path, $table);
	}
 return $mem_path;
}

sub create_meta_info {
   my $self = shift; my $dbh = $self->{dbh};
   my $table = lc(shift); my $parent = lc(shift) || 'mem';
   my $src_lang = undef, $tra_lang = undef;
   foreach (@_) {
		print "ARG $_\n";
		$src_lang = lc($1) if /src\P{Letter}?(?:La?n?g?)?=(.+)/i; $tra_lang = lc($1) if /tra\P{Letter}?(?:La?n?g?)?=(.+)/i;	# supports syntax: srcLang, src_lang, src, srcLng, ...
   }
   my $mem_path = $self->memPath($parent, $table, $src_lang, $tra_lang);
   $self->do_insert_meta_info ($mem_path, $srcLang, $traLang);
   return (mem_path => $mem_path, stdParent => substr($parent_path, 0, index($parent_path, $self->pathSeparator())));
}

sub update_meta_info {} # Nothing to update
sub cancel_all {
  my ($self, %meta) = @_;
  $self->{dbh}->do ("delete from public.meta_info where mem_path = '$meta{mem_path}'");
}

sub checkId_sql { 
	my (undef,undef,%args) = @_; 
	my $memPath1 = $args{mem_path}; $memPath1 =~ s/(\w)$/chr(ord($1) + 1)/e;
	"mem_path text not null default '$args{mem_path}' check(mem_path >= '$args{mem_path}' and mem_path < '$memPath1')" 
}
 
sub createIdRules {
	my ($self, $table, %args) = @_;
	print STDERR "createIdRules $table $args{mem_path} $args{stdParent}\n";
	if ($args{mem_path} && $args{stdParent} && ($args{stdParent} ne $table)) {
		my $table1 = $table; $table1 =~ s/\./_/;
		$self->{dbh}->do("create rule r_$table1 as 
					          on insert to $args{stdParent} where mem_path='$args{mem_path}'
					          do instead insert into $table values (new.*)")
			or die $DBI::errstr;
	}
}
 
1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
