=head1 MODE by_path::noLangs

Tables contain a string as discriminant. All lines contain this value, so it takes more space on disk. 

This mode is ideal if you use the REST server, with a frequent use of personal table inheritance: 
when querying a parent table, the path is used to make the distinction between entries coming from different children,
even if you call it from the REST service.

Path contains only qualified table names.

=cut
package by_path::noLangs::TableCreator;

use parent by_path::TableCreator;

sub pathSeparator { ':' }

sub loadTables {
 	my ($self, $dir, $dbh) = @_;
	$self->SUPER::loadTables ($dir ? "$dir/by_path/noLangs" : substr($INC{'by_path/noLangs/TableCreator.pm'}, 0, rindex($INC{'by_path/noLangs/TableCreator.pm'},'/')), $dbh || $self->{dbh});
	$self->SUPER::loadTables ($dir || substr($INC{'TableCreator.pm'}, 0, rindex($INC{'TableCreator.pm'},'/')), $dbh || $self->{dbh});
}

sub do_insert_meta_info {
  my ($self, $mem_path, $srcLang, $traLang) = @_;
  $self->{dbh}->do("insert into PUBLIC.META_INFO (MEM_PATH, SRC_LANG, TRA_LANG) values ('$mem_path', '$srcLang', '$traLang')");
  if ($self->{dbh}->state eq '42P01') {
    $self->recursive_create_table ('public.meta_info'); $self->{dbh}->do($TableCreator::reqStr{VIEW}{'public.meta_view'});
    $self->{dbh}->do("insert into PUBLIC.META_INFO (MEM_PATH, SRC_LANG, TRA_LANG) values ('$mem_path', '$srcLang', '$traLang')") or die $DBI::errstr;
  }
}

1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
