=head1 MODE by_void

Tables contain no discriminant at all, so takes less space on disk. 
This mode is ideal for direct access with your favorite plugin (since in this mode each connected client always access to the same table) 
unless you make use of inheritance and want to know, when you retreive a result from a parent table, from which child table it comes from.

=cut
package by_void::TableCreator;

use parent TableCreator;

sub loadTables {
 	my ($self, $dir, $dbh) = @_;
	$self->SUPER::loadTables ($dir ? "$dir/by_void" : substr($INC{'by_void/TableCreator.pm'}, 0, rindex($INC{'by_void/TableCreator.pm'},'/')), $dbh || $self->{dbh});
	$self->SUPER::loadTables ($dir || substr($INC{'TableCreator.pm'}, 0, rindex($INC{'TableCreator.pm'},'/')), $dbh || $self->{dbh});
}

sub can_inherit { 1 }	# by_void mode supports multiple inheritance, so always true.

# do insertion after table creation, so that it exists only if table creation is OK
sub create_meta_info {}	
sub update_meta_info {
   my $self = shift; 
   my $table = shift; my $parent = shift || 'mem';
   my $src_lang = undef, $tra_lang = undef;
   foreach (@_) {
		print "ARG $_\n";
		$src_lang = $1 if /src\P{Letter}?(?:La?n?g?)?=(.+)/i; $tra_lang = $1 if /tra\P{Letter}?(?:La?n?g?)?=(.+)/i;	# supports syntax: srcLang, src_lang, src, srcLng, ...
   }   
   if ($src_lang || $tra_lang) {
	   my ($schema, $table1) = split(/\./,$table); unless ($table1) { ($schema,$table1) = ('public',$table); }
	   my $meta = $self->{dbh}->prepare ('insert into meta_info (table_schema, table_name, src_lang, tra_lang) values (?,?,?,?)');
		unless ($meta->execute (lc($schema), lc($table1), lc($src_lang) || '', lc($tra_lang) || '')) {
			$self->recursive_create_table ('public.meta_info');
			$meta->execute (lc($schema), lc($table1), lc($src_lang) || '', lc($tra_lang) || '');
		}
   }
}
sub cancel_all { }	# Nothing to be done, because meta insertion occurs after

sub checkId_sql { '' }
 
sub createIdRules {}
 
1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
