create or replace function tokenize (st text, dict text, stopwords boolean) returns text immutable as $$
	-- using tsearch2
     select array_to_string(
                  array_agg(case 
                              when $3 and array_length(lexize($2,n), 1) = 0 then n 
                              else array_to_string(lexize($2,n), ' ')  
                             end)
            ,' ')
       from unnest(regexp_split_to_array($1, E'\\W+')) as n
$$ language sql;

create or replace function score(a text, b text) returns double precision as
$$
	-- using fuzzystrmatch
   select
        case
        when $1 = $2 then 1.0                         -- not only for optimisation:  also prevents division by 0 if a = b = '' 
        when x.i1 < 255 and x.i2 < 255 then         -- normal case : use levenshtein
          1.0 - 1.0 * levenshtein($1,$2) / greatest(i1, i2)
        when substring($1,1,1) = substring($2,1,1) then  -- identical left : use levenshtein on right part
             (select 1.0 - (1.0 - score(substring($1,l.m + 1, i1 - l.m), substring($2, l.m + 1, i2 - l.m))) * (greatest(i1,i2) - l.m)  / greatest(i1, i2)
               from ( select max(i) as m from generate_series(1, least(i1, i2)) i where substring($1,1,i) = substring($2,1,i) ) l) 
        when substring($1,i1,1) = substring($2,i2,1) then        -- identical right: use levenshtein on left part
             (select 1.0 - (1.0 - score(substring($1,1,i1 - l.m), substring($2, 1,i2 - l.m))) * (greatest(i1,i2) - l.m)  / greatest(i1, i2)
               from ( select max(i) as m from generate_series(1, least(i1, i2)) i where substring($1,i1 - i + 1,i) = substring($2,i2 - i + 1,i) ) l) 
        else   -- cannot use levenshtein, so we use similarity
           similarity($1,$2)
        end
   from (select octet_length($1) as i1, octet_length($2) as i2) x
$$ language sql;

create or replace function parent_table (name text) returns text as
$$
      SELECT pg_namespace.nspname || '.' || pg_class.relname
      FROM pg_catalog.pg_inherits
        INNER JOIN pg_catalog.pg_class ON (pg_inherits.inhparent = pg_class.oid)
          INNER JOIN pg_catalog.pg_namespace ON (pg_class.relnamespace = pg_namespace.oid)
          WHERE inhrelid = $1::regclass
$$ language sql;
