#! /usr/bin/env perl

=head1 test-dbspec.pl

Tests db/DbCreator.pm/analyse_dbSpec(...)

=cut

use lib '../db';
use DbCreator;

# 0. Use the script to analyze a name 
if (my $param = shift) {
	my ($dbName, $host, $port, $user, $pass, $dbnameSpec) = DbCreator::analyse_dbSpec ($param); # Call as array
	print "Database name : $dbName\n";
	print "Host name : $host\n";
	print "Port : $port\n";
	print "User : $user\n";
	print "Password : $pass\n";
	print "Specification : $dbnameSpec\n";
	
	my $DBI = DbCreator::analyse_dbSpec ($param); # Call as scalar
	print "DBI : $DBI\n";
	exit;	
}

# 1. Complete specification
my $spec = 'myUser12:myPass54#myOwner@myHost31.myDomain.fr:5434/myDb923';
my $dbi = DbCreator::analyse_dbSpec ($spec);
if ($dbi eq 'dbi:Pg:dbname=myDb923;host=myHost31.myDomain.fr;port=5434;username=myUser12;password=myPass54;owner=myOwner') {
	print "Full spec OK : $spec --> $dbi\n";
} else {
	die "Full spec ERROR : $spec --> $dbi\n";

}
my @params = DbCreator::analyse_dbSpec ($spec);
die "Bad db name" unless shift(@params) eq 'myDb923';
die "Bad host" unless shift(@params) eq 'myHost31.myDomain.fr';
die "Bad port" unless shift(@params) == 5434;
die "Bad user" unless shift(@params) eq 'myUser12';
die "Bad password" unless shift(@params) eq 'myPass54';
die "Bad password" unless shift(@params) eq 'myOwner';
die "Bad db spec" unless shift(@params) eq $dbi;
print "All params OK\n";

# 2. No password
my $spec = 'myUser59@myHost39.myDomain.fr:5434/myDb923';
my $dbi = DbCreator::analyse_dbSpec ($spec);
if ($dbi eq 'dbi:Pg:dbname=myDb923;host=myHost39.myDomain.fr;port=5434;username=myUser59') {
	print "No password OK : $spec --> $dbi\n";
} else {
	die "No password ERROR : $spec --> $dbi\n";

}
my @params = DbCreator::analyse_dbSpec ($spec);
die "Bad db name" unless shift(@params) eq 'myDb923';
die "Bad host" unless shift(@params) eq 'myHost39.myDomain.fr';
die "Bad port" unless shift(@params) == 5434;
die "Bad user" unless shift(@params) eq 'myUser59';
die "Bad password" unless shift(@params) eq '';
die "Bad owner" unless shift(@params) eq '';
die "Bad db spec" unless shift(@params) eq $dbi;
print "All params OK\n";

# 3. No port
my $spec = 'myUser12:myPass54@myHost38.myDomain.fr/myDb927';
my $dbi = DbCreator::analyse_dbSpec ($spec);
if ($dbi eq 'dbi:Pg:dbname=myDb927;host=myHost38.myDomain.fr;username=myUser12;password=myPass54') {
	print "No port OK : $spec --> $dbi\n";
} else {
	die "No port ERROR : $spec --> $dbi\n";

}
my @params = DbCreator::analyse_dbSpec ($spec);
die "Bad db name" unless shift(@params) eq 'myDb927';
die "Bad host" unless shift(@params) eq 'myHost38.myDomain.fr';
die "Bad port" unless shift(@params) == 0;
die "Bad user" unless shift(@params) eq 'myUser12';
die "Bad password" unless shift(@params) eq 'myPass54';
die "Bad owner" unless shift(@params) eq '';
die "Bad db spec" unless shift(@params) eq $dbi;
print "All params OK\n";

# 4. No host
my $spec = 'myUser59:pass72@:5438/myDb923';
my $dbi = DbCreator::analyse_dbSpec ($spec);
if ($dbi eq 'dbi:Pg:dbname=myDb923;port=5438;username=myUser59;password=pass72') {
	print "No host OK : $spec --> $dbi\n";
} else {
	die "No host ERROR : $spec --> $dbi\n";

}
my @params = DbCreator::analyse_dbSpec ($spec);
die "Bad db name" unless shift(@params) eq 'myDb923';
if (my $host = shift(@params)) { die "Bad host = $host"; }
die "Bad port" unless shift(@params) == 5438;
die "Bad user" unless shift(@params) eq 'myUser59';
die "Bad password" unless shift(@params) eq 'pass72';
die "Bad owner" unless shift(@params) eq '';
die "Bad db spec" unless shift(@params) eq $dbi;
print "All params OK\n";
