###
# Version of Musci for CRuby / Pg

require 'pg'

module Musci
   
   class Connection
       def initialize(dbname, user = nil, password = nil, host = nil, port = nil, options = nil, tty = nil) 
           if user == nil then
              if dbname =~ /^\#(.+)$/ then
                  dbname = Musci::alias($1)
                  if dbname.is_a? Hash then
                      h = dbname
                      dbname = h['db']
                      user = h['user']; password = h['pass']
                      port = h['port']; host = h['host']
                  end
              end
              if dbname =~ /:/ then # 1-parameter format
                  dbname, user, password, host, port, options, tty = dbname.split(':').map { |item| item == nil ? nil : item.length == 0 ? nil : item }
              end
           end
           Musci::token_connection(dbname)  # may reject or wait if too many connections
           @conn = PG::Connection.open(host, port, options, tty, dbname, user, password) 
           @dbName = dbname
       end
       
       attr_reader :dbName
       
       def exec(sql, params = nil, type = nil, fieldId = nil, &sub)
           res = action = nil
           if type == Object then
               action = lambda { |row| res = row[fieldId] }
           elsif type == Array then
               res = Array.new
               action = lambda { |row| res << row[fieldId] }
           elsif block_given? then
               action = sub
           else
               action = lambda {}  # do nothing
           end
          if params == nil
              @conn.exec(sql) { |set| set.each { |row| action.call(row) } }
          else
              Statement.new(sql,@conn).exec(params) { |set| set.each { |row| action.call(row) } }
          end
          return res
       end
       
       def prepare(name,sql) PreparedStatement.new(name,sql,@conn) end
        
       def close() @conn.close(); Musci::free_connection(@dbName) end        
   end
   
   class Statement
       def initialize(sql,conn)
           @sql = sql
           @conn = conn
           @paramNames = []
           @sql.gsub!(/[\$\:](\w+)/) { @paramNames << $1; "$#{@paramNames.count}" }           
           i = 0; @sql.gsub!(/\?/) { i = i + 1 ; "$#{i}" }           
       end
       
       def pack_params(params)
           if params.is_a? Hash then 
               return @paramNames.collect { |name| params[name] }
           elsif not params.is_a? Array then
               return [params]
           else
               return params
           end
       end
       
       def exec(params = nil, &sub)
           @conn.exec_params(@sql,pack_params(params)) { |res| res.each { |row| yield row } if block_given? }
       end
   end
   
   class PreparedStatement < Statement
       def initialize(name,sql,conn)
           super(sql,conn)
           @name = name
           @conn.prepare(@name,@sql)
       end
       
       def exec(params = nil, type = nil, fieldId = nil, &sub)
           res = action = nil
           if type == Object then
               action = lambda { |row| res = row[fieldId] }
           elsif type == Array then
               res = Array.new
               action = lambda { |row| res << row[fieldId] }
           elsif block_given? then
               action = sub
           else
               action = lambda {}  # do nothing
           end
           @conn.exec_prepared(@name,pack_params(params)) { |set| set.each { |row| action.call(row) } }
           return res
       end
   end
    
end
