#! /usr/bin/ruby

if ARGV.count < 4
    puts "Syntax: "
    puts "\t#{__FILE__} DB-Name(:user:password)?(:host:port)? <import-dir> <search-input> <search-output>"
    exit
end

$count_procs = 1 # default
if ARGV[0] =~ /^\#/ then # using memory alias definition from config
    require 'yaml'; config = YAML.load_file "#{File.dirname(__FILE__)}/../conf/elefas.yml"
    $LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation
    require 'musci'; Musci::add_aliases(config['memories']) 
    $count_procs = config['deamon']['max_procs'] if config['deamon'] != nil
end


db = ARGV.shift
importDir = ARGV.shift 
searchInputDir = ARGV.shift 
searchOutputDir = ARGV.shift
$count_procs = $1.to_i if ARGV.count > 0 and ARGV.shift =~ /(\d+)/

require 'date'
require 'fileutils'
require 'zip'

trap('CLD') { $count_procs += 1 }

def action(file, txt, &sub)
    act = lambda { 
        sub.call 
        File.delete(file)
        puts "#{DateTime.now.strftime} - #{txt}"
    }
    if $count_procs > 1 then
       $count_procs -= 1
       Thread.new { act.call }
    else
       act.call # no more process
    end
end

while true
    if Dir.empty?(importDir) and Dir.empty?(searchInputDir) then 
        sleep 5
    else
        Dir.each_child(importDir) do |file|
            puts "#{DateTime.now.strftime} - Found in #{importDir} file #{file}"            
            next unless file =~ /\.(tmx|zip)$/
            next unless File.file? "#{importDir}/#{file}"
            if file =~ /\.tmx$/ then
                FileUtils.mv("#{importDir}/#{file}", "/tmp/#{file}")
                action("/tmp/#{file}", "Imported file #{file}") { 
                    system "#{File.dirname(__FILE__)}/ef-import.rb", db, "/tmp/#{file}"
                }
            elsif file =~ /\.zip$/ then  # archive of xliff files
                puts "#{DateTime.now.strftime} - Merging file #{file}"            
                file.gsub! /\.zip$/, ''
                Dir.mkdir "/tmp/#{file}"
                Zip::File.open("#{importDir}/#{file}.zip") do |zip_file|
                    zip_file.each do |zentry|
                        fpath = File.join("/tmp/#{file}", zentry.name)
                        zip_file.extract(zentry, fpath) unless File.exist?(fpath)                    
                    end
                end
                File.delete("#{importDir}/#{file}.zip")
                system "#{File.dirname(__FILE__)}/sg_mergeToTmx.rb /tmp/#{file}.tmx /tmp/#{file}/*"
                system "rm", "-Rf", "/tmp/#{file}"
                puts "#{DateTime.now.strftime} - Importing file /tmp/#{file}.tmx"  
                action("/tmp/#{file}.tmx", "Imported file #{file}.tmx") { 
                    system "#{File.dirname(__FILE__)}/ef-import.rb", db, "/tmp/#{file}.tmx"
                }            
            end
        end        
        Dir.each_child(searchInputDir) do |file|
            puts "#{DateTime.now.strftime} - Found in #{searchInputDir} file #{file}"
            puts File.file?("#{searchInputDir}/#{file}")
            next unless File.file? "#{searchInputDir}/#{file}"
            FileUtils.mv("#{searchInputDir}/#{file}", "/tmp/#{file}")
            lang = 'en' ; lang = $1 if file =~ /[\-\._]([a-zA-Z][a-zA-Z])\./
            action("/tmp/#{file}", "Executed search #{file} language #{lang}") {
                system "#{File.dirname(__FILE__)}/ef-find.rb '#{db}' #{lang} --query-file '/tmp/#{file}' > '#{searchOutputDir}/#{file}-res.tmx.running'"
                FileUtils.mv("#{searchOutputDir}/#{file}-res.tmx.running", "#{searchOutputDir}/#{file}-res.tmx")
            }            
        end
    end
end

