module Spongiae
   module Formats
       
       class Selector
           attr_reader :module, :class
           
           def initialize(mod,cls)
               @module = mod; @class = cls
           end
           
           def load! 
               require "spongiae/formats/#{@module}" 
           end
           
           def create(file,props = {})
               "Spongiae::Formats::#{@class}".split('::').inject(Object) {|o,c| o.const_get c}.new(file,props)
           end
           
           def sniff(file)
               self
           end
       end
       
       class XmlSniffer
           def sniff(file)
               File.open(file, "r:UTF-8") do |f|
                   while line = f.gets
                       return Selector.new('android', 'AndroidStrings') if line =~ /<resources/
                       return Selector.new('docbook', 'Docbook') if line =~ /<!DOCTYPE/ and line =~ /DocBook/
                   end
               end
           end
       end
       
       # Special hash for extensions:
       # - case insensitive unless starts with '.'
       # - key can be regex, in which case any matching proposal will match
       class ExtensionsHash < Hash
           def initialize(h)
               h.each { |k,v| self[k] = v }
           end
           
           def [](idx)
               return super(idx.downcase) if key? idx.downcase
               return super(".#{idx}") if key? ".#{idx}"    # case sensitive
               self.each do |k,v|
                   return v if k.is_a? Regexp and idx =~ k
               end
               return nil
           end
        end
       
       
       ALL = ExtensionsHash.new({
            'txt' => Selector.new('text','PlainText'),
           'properties' => Selector.new('java_properties', 'JavaProperties'),
           /pot?/ => Selector.new('gettext', 'GettextPo'),
           'srt' => Selector.new('srt', 'Srt'),
           /html?/i => Selector.new('html', 'HtmlDocument'),
           'odt' => Selector.new('opendoc', 'OpenDocFile'),
           'odp' => Selector.new('opendoc', 'OpenDocFile'),
           'ods' => Selector.new('opendoc', 'OpenDocFile'),
           'docx' => Selector.new('openxml', 'OpenXmlFile'),
           /\w*xli?ff?/i => Selector.new('xliff', 'XliffFilter'),
           'xml' => XmlSniffer.new
        })
       
   end
end
