#! /usr/bin/ruby

if ARGV.count < 2
    puts "Syntax: #{__FILE__} DB-Name(:user:password)?(:host:port)? <table> <interval>"
    exit
end

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

if ARGV[0] =~ /^\#/ then # using memory alias definition from config
    require 'yaml'; config = YAML.load_file "#{File.dirname(__FILE__)}/../conf/elefas.yml"
    require 'musci'; Musci::add_aliases(config['memories']) 
end

require 'elefas/write'
cleaner = Elefas::ElefasCleaner.new(ARGV.shift)
cleaner.clean! ARGV.shift, ARGV.shift
cleaner.close
