#! /usr/bin/ruby


if ARGV.count < 2
    puts "Syntax: #{__FILE__} DB-Name(:user:password)?(:host:port)? file"
    exit
end

$LOAD_PATH << "#{File.dirname(__FILE__)}/../lib"                # For non-standard installation

if File.exist?  "#{File.dirname(__FILE__)}/../conf/castor.yml" then
   require 'yaml'; config = YAML.load_file "#{File.dirname(__FILE__)}/../conf/castor.yml"
end

require 'musci'
dbParamsSet = ARGV.shift
if dbParamsSet =~ /^#(\w+)/ then
   dbParamsSet = config['databases'][$1]
   if dbParamsSet == nil then
       puts "Database #{$1} not found in configuration file"
       exit
   elsif dbParamsSet.is_a? Hash then
      dbParams = [ dbParamsSet['db'], dbParamsSet['user'], dbParamsSet['pass'], dbParamsSet['host'], dbParamsSet['port'] ]
   elsif dbParamsSet.is_a? String then
      dbParamsSet = dbParamsSet.split(':'); dbParams = []
      for i in 0..6
          if dbParamsSet.count > i then dbParams[i] = dbParamsSet[i] else dbParams[i] = nil end
      end
   end
else
    dbParamsSet = dbParamsSet.split(':'); dbParams = []
    for i in 0..6
        if dbParamsSet.count > i then dbParams[i] = dbParamsSet[i] else dbParams[i] = nil end
    end
end
conn = Musci::Connection.new(dbParams[0], dbParams[1], dbParams[2], dbParams[3], dbParams[4], dbParams[5], dbParams[6])


file = ARGV.shift
doc_id = nil
conn.exec("select doc_id from CR_DOCUMENTS where fileName = :file", { 'file' => file }) { |row| doc_id = row[1] }
conn.exec("delete        from CR_SEGMENTS where document = :id", { 'id' => doc_id })
conn.exec("delete        from CR_DOCUMENTS where fileName = :file", { 'file' => file })
