###
# Version of Musci for CRuby / Pg

require 'pg'

module Musci
   
   class Connection
       def initialize(dbname, user = nil, password = nil, host = nil, port = nil, options = nil, tty = nil) 
           @conn = PG::Connection.open(host, port, options, tty, dbname, user, password) 
       end
       
       def exec(sql, params = nil, &sub)
          if params == nil
              @conn.exec(sql) { |res| res.each { |row| sub.call(row) } if sub != nil }
          else
              Statement.new(sql,@conn).exec(params) { |res| res.each { |row| sub.call(row) } if sub != nil }
          end
       end
       
       def prepare(name,sql) PreparedStatement.new(name,sql,@conn) end
   end
   
   class Statement
       def initialize(sql,conn)
           @sql = sql
           @conn = conn
           @paramNames = []
           @sql.gsub!(/[\$\:](\w+)/) { @paramNames << $1; "$#{@paramNames.count}" }           
       end
       
       def exec(params = nil, &sub)
           @conn.exec_params(@sql,@paramNames.collect { |name| params[name] }) { |res| res.each { |row| sub.call(row) } if sub != nil }
       end
   end
   
   class PreparedStatement < Statement
       def initialize(name,sql,conn)
           super(sql,conn)
           @name = name
           @conn.prepare(@name,@sql)
       end
       
       def exec(params = nil, &sub)
           @conn.exec_prepared(@name,@paramNames.collect { |name| params[name] }) { |res| res.each { |row| sub.call(row) } if sub != nil }
       end
   end
    
end
