
# ------ Extend class String so that it can behave like a TaggedString
class String
    def to_native_xml()
        phrase = self if phrase == nil
        return phrase.encode(:xml => :text)
    end
    def to_xliff(segmented: true) to_native_xml() end
    def restore_tags(unit) self end
    def placeables() [] end
    def untagged() self end
end


module Spongiae
   module Tags    
       
       class Tag
           # 1 = opening, 0 = isolated, -1 = close
           attr_accessor :type
       end
       
       # For XML and HTML
       class MarkupTag < Tag
           attr_accessor :name, :attrs
           attr_accessor :id
           
           # Convert to xml/h
           def to_native_xml
               res = "<#{@name}"
               attrs.each { |k,v| res = res + " #{k} = #{v.encode(:xml => :attr)}" } unless attrs == nil or @type < 0
               case @type
               when -1 then res.insert(1, '/'); res = res + ">"
               when  0 then res = res + " />"
               when +1 then res = res + ">"
               end
               return res
           end
           
           def to_xliff(segmented: true)
               case @type
               when -1 then 
                   if segmented then return "<ept id=\"#{@id}\" />" else return "</g>" end
               when  0 then 
                   return "<x id=\"#{@id}\" />" 
               when +1 then 
                   if segmented then return "<bpt id=\"#{@id}\" />" else return "<g id=\"#{@id}\">" end
               end
           end
       end
       
       # Anything which should not be translated. Can be a tag or something else
       class Placeable
           attr_accessor :pos, :item
           
           def initialize(pos,item) @pos = pos ; @item = item end
               
           def to_native_xml() @item.to_native_xml end
           def to_xliff(segmented: true) @item.to_xliff(segmented: segmented) end
       end
       
       class TaggedString
           attr_accessor :text, :placeables
           
           def initialize(text, placeables = []) @text = text; @placeables = placeables end
               
           # Convet to string with tags
           def to_any_xml(&sub)               
               phrase = @text
               return phrase.encode(:xml => :text) unless placeables.count > 0
               
               prev = nil
               placeables.reverse_each do |item|
                   if prev == nil then 
                       phrase[item.pos,phrase.length] = phrase[item.pos,phrase.length].encode(:xml => :text)
                   else
                       phrase[item.pos,prev - item.pos] = phrase[item.pos,prev - item.pos].encode(:xml => :text)                       
                   end
                   phrase.insert(item.pos,sub.call(item.item)) 
                   prev = item.pos
               end
               phrase[0,prev] = phrase[0,prev].encode(:xml => :text) if prev != nil
               return phrase
           end
           def to_native_xml() to_any_xml { |item| item.to_native_xml } end
           def to_xliff(segmented: true) to_any_xml { |item| item.to_xliff(segmented: segmented) }  end
           # Remove tags
           def untagged() @text end
               
           # Synchronise tags between source and target
           def restore_tags(unit) 
               oriTags = unit.srcText.placeables
               @placeables.each do |tra|
                   if tra.item.name == nil then
                       oriTags.each do |ori|
                           if ori.item.id.to_s == tra.item.id.to_s then 
                               tra.item.name = ori.item.name 
                               tra.item.attrs = ori.item.attrs if ori.item.type >= 0
                           end
                       end
                   end
               end
               return self
           end
       end
       
       def self.untag(part) part.gsub(/<\/\w+>/, '') end
   end
end
