=head1 CPAN 

Base class for CPAN-based formats. This class itself does not depend on CPAN modules but it is abstract.

=cut
package Silvestris::Cyclotis::Format::cpan;
use parent Silvestris::Cyclotis::Format;

use Dancer qw(var);

sub produce {
    my ($self, $st, $query, $tableRef, $view, $filter) = @_;
	my %v = $self->VERSION_INFO(); $view ||= ''; 
	if ($view =~ /check/) { return $self->dump({ status => 'OK', info => { cyclotis => \%v}}); }
	elsif ($view =~ /count/) { 
		my $count = 0; $count++ while $st->fetchrow_array; var 'results_count' => $count;
		return $self->dump({ status => 'OK', info => { cyclotis => \%v}, count => $count });
	}
	else { 
		my $ref = [ $self->produce_lines($st, $tableRef) ]; var 'results_count' => scalar(@$ref);
		if ($filter) { 
			foreach my $line(@$ref) {
				$line->{src} = &$filter ($line->{src}, $query, $line);
				$line->{tra} = &$filter ($line->{tra}, $query, $line);
			}
		}
		unless (defined ($self->{envelope}) and $self->{envelope} == 0) {
			$ref = {
				status => 'OK', info => { cyclotis => \%v, query => $query }, 
				result => $ref
			};
			if ($self->{'display-date'}) { my @t = localtime; $t[5] += 1900; $t[4]++; $ref->{info}{date} = "$t[5]-$t[4]-$t[3] $t[2]:$t[1]:$t[0]"; }
		}
		return $self->dump($ref);
	}
}

sub produce_lines {
	my ($self, $st, $tableRef) = @_; my @res;
LINE:
    while (my $line = $st->fetchrow_hashref) {
		$tableRef->expand($line) if $tableRef->has_structured_content(); $self->reformat_dates ($line);
		push(@res, $line);
    }
	return @res;
}

sub produce_write_response {
	my ($self, $lines) = @_; my $ref; my %v = $self->VERSION_INFO();
	unless (defined ($self->{envelope}) and $self->{envelope} == 0) {
		$ref = {
			status => 'OK', info => { cyclotis => \%v }, 
			result => $lines, count => scalar(@$lines)
		};
	} else {
		$ref = $lines;
	}
  
  return $self->dump($ref);
}

sub produce_info { 
	my $self = shift; my %v = $self->VERSION_INFO(); 
	my @tables; @tables = split(/,/, $_[-1]) if $_[-1] =~ /,/;
	$self->dump({
		status => 'OK', info => { cyclotis => \%v, query => $_[0] },
		config => { formats => shift, url => shift, allow => shift, timestamp => shift, tables => { read => $tables[0], write => $tables[1] } }
	}) 
}

sub struct_info {
	my ($self, %tables) = @_; $self->dump({
		status => 'OK', info => { query => 'struct info' },
		tables => \%tables
	}) 
}

sub show_status {
	my ($self, $level, $types, $Queries, $Lib) = @_; my %res;
	unless ($types !~ /cache/) {
		$res{cache}{tables} = scalar keys (%Silvestris::Cyclotis::Database::Table::CACHE); 
		$res{cache}{queries} = scalar @$Queries; 
		if ($level > 1) { 
			$res{cache}{tables} = { count => $res{cache}{tables}, items => [keys (%Silvestris::Cyclotis::Database::Table::CACHE)] }; 
			$res{cache}{queries} = { count => scalar (@$Queries), items => $Queries }; 
		}
	}
	unless ($types !~ /libs/) {
		$res{libs} = $Lib;
	}
	$self->dump(\%res)
}

sub show_log {
	my $self = shift; my $log = shift; return $self->dump($log);  
}

1;

=head1 LICENSE

Copyright 2014-2016 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
