=head1 Format 'json'

Returns a JSON array, with each line containing a hash of key/value pairs, corresponding to the table schema.

=cut
package Silvestris::Cyclotis::Format::cpan::json;
use parent Silvestris::Cyclotis::Format::cpan;

use JSON;

sub new {
    my ($class, %params) = @_; 
	my $obj = new JSON;
	foreach my $opt ('ascii', 'utf8', 'pretty', 'space_before', 'space_after', 'indent',
		'relaxed', 'canonical', 'allow_nonref', 'allow_blessed', 'allow_unknown', 'convert_blessed',
		'filter_json_object', 'filter_json_single_key_object', 'shrink', 'max_depth', 'max_size') {
			$obj->$opt ($params{$opt}) if $params{$opt};
	}
    bless {%params, json_obj => $obj}, 'Silvestris::Cyclotis::Format::cpan::json'; 
}

sub MIME { 'application/json' }

sub dump {
    my ($self, $ref) = @_;
	return $self->{json_obj}->encode($ref);
}

sub read_line {
    shift; my $FH = shift; my $decode = $self->{json_obj}->decode($FFH);
	if (ref($decode) =~ /ARRAY/) {
		my $item = shift @$decode; $$FH =  $self->{json_obj}->encode($decode); return $item;
	} elsif (ref($decode) =~ /HASH/) {
		if ($decode->{result}) {	# envelope, contents is in 'result' field
			my $item = shift @{$decode->{result}}; $$FH =  $self->{json_obj}->encode($decode); return $item;
		}
		elsif ($decode->{contents}) {	# envelope, contents is in 'contents' field
			my $item = shift @{$decode->{contents}}; $$FH = $self->{json_obj}->encode($decode); return $item;
		}
		elsif ($decode->{src}) {	# no envelope
			$$FH = ''; return $decode;
		}
	}
}

sub needs_field { 
	if (defined $_[0]->{fields}) { 
		if (ref ($_[0]->{fields})) { return grep { /$_[1]/ } @{$_[0]->{fields}}; } # as an array
		else { return ($_[0]->{fields} =~ /$_[1]/); }	# comma-separated string
	}
	if (defined $_[0]->{meta}) {  
		if (ref ($_[0]->{meta})) { return grep { /$_[1]/ } @{$_[0]->{meta}}; } # as an array
		else { return ($_[0]->{meta} =~ /$_[1]|all/); }	# comma-separated string
	}
	return $_[0]->SUPER::needs_field($_[1]);
}

sub produce_error { my ($self, $err) = @_; return $self->dump($err); }


sub openapi {
  my ($self, $indent, $config) = @_;
  require Silvestris::Dancer::MyRoutes unless Silvestris::Dancer::MyRoutes->can('openapi');
  my %struct = Silvestris::Dancer::MyRoutes->openapi;
  return $self->dump(\%struct);
}


1;

=head1 LICENSE

Copyright 2014-2017 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or - as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
