#! /usr/bin/env plackup

=head1 DESCRIPTION

This file adds a hook to cyclotis-rest-api.pl
This removes the entries in the database which 

=cut

use Dancer;

use Silvestris::Cyclotis::Database::Table;
use Silvestris::Dancer::MyRoutes;
use Dancer::Plugin::Database;

my $cleanerConf = config->{'cleaner'};
my $debug = sv_debug('cleaner'); 


# addHookBefore (%HASH, $name, $entriesName, $rule, $dateSub, $delAction)
#	adds a hook which order %HASH keys against $dateSub, then depending on $rule applies $delAction to least recent keys.
sub addHookBefore {
	my ($HASH, $name, $rule, $dateSub, $delAction) = @_;
	if ($rule =~ /^(.+);(.+)$/) { # recursive
		addHookBefore($HASH,$name, $1, $dateSub, $delAction);
		addHookBefore($HASH,$name, $2, $dateSub, $delAction);		
	}
	if ($rule =~ /^\s*(\d+)\s*$/) {		# keep a definite number of entries in memory
		my $maxNumber = $1;
		hook before => sub {
			if (scalar keys (%$HASH) < $maxNumber) { &$debug("Cleaner $name : no work\n") if $debug; }
			else {
				my @keys = sort { &$dateSub($a) <=> &$dateSub($b) } keys (%$HASH);
				&{$debug} ("Cleaner $name (before): " . scalar(keys (%$HASH)) . " $name(s)");
				until (scalar @keys <= $maxNumber) {
					my $key = shift @keys; &$delAction($key);
					&{$debug} ("Cleaner $name (working): remove $name $key\n") if $debug;
				}
				&{$debug} ("Cleaner $name (after): " . scalar(keys (%$HASH)) . " $name(s)") if $debug;
			}
		};
	} elsif ($rule =~ /^\s*(\d+)\s*([smhdw])\s*$/i) {	# lifetime specification : each entry lives a specific duration
		my $duration = $1; # duration
		# Convert to seconds
		my $unit = $2; $duration *= 60 if $unit !~ /s/i; $duration *= 60 if $unit !~ /[sm]/i; $duration *= 24 if $unit !~ /[smh]/i; $duration *= 7 if $unit !~ /[smhd]/i;	
		
		hook before => sub {
			my $start = time() - $duration; # minimal accepted time
			my @keys = grep { &$dateSub($_) < $start } keys (%$HASH);
			unless (@keys) { &$debug("Cleaner $name : no work\n") if $debug; return; }
			&$debug("Cleaner $name (before): " . scalar(@keys) . " $name(s)") if $debug;
			foreach my $key (@keys) { &$delAction($key); }
			&$debug("Cleaner $name (after): " . scalar(keys (%$HASH)) . " $name(s)") if $debug;		
		};	
	}
}

addHookBefore(\%Silvestris::Cyclotis::Database::Table::CACHE, 'table', $cleanerConf->{'table-info'}, 
	sub { my $key = shift; return $Silvestris::Cyclotis::Database::Table::CACHE{$key}{'last-internal-use'}; },
	sub {
		my $key = shift; 
		delete $Silvestris::Cyclotis::Database::Table::CACHE{$key}; 
		my @delQueries = grep { /$key/ } keys (%{database(param('db'))->{CachedKids}});
		foreach ( @delQueries ) { delete database->{CachedKids}{$_}; }
		&$debug("\tAlso deleted ", scalar (@delQueries), " queries\n") if $debug and @delQueries;
	}
);

addHookBefore(\%Silvestris::Users::Cache, 'user', $cleanerConf->{'users'}, 
	sub { my $key = shift; return $Silvestris::Users::Cache{$key}[2]; },
	sub { my $key = shift; delete $Silvestris::Users::Cache{$key}; }
);

addHookBefore(\%Silvestris::Users::Bearers, 'bearers', $cleanerConf->{'bearers'} || config->{'auth-db'}{'bearer'}{'life'},
	sub { my $key = shift; my @s = split(/:/, $Silvestris::Users::Bearers{$key}); return $s[2]; },
	sub { my $key = shift; delete $Silvestris::Users::Bearers{$key}; }
);


=head1 LICENSE

Copyright 2014-2018 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
