#! /usr/bin/env perl

=head1 test-formats.pl

Tests whenever read_all method works for several formats

=cut

use lib '../rest';
use Silvestris::Cyclotis::Format;



sub test {
	my $FORMAT = shift; my $LINES = shift; my $VALUES = shift;

	print "Testing format $FORMAT...\n"; my $cpt = 0;
	while (my $line0 = shift (@$VALUES)) {
		my %readLine = $FORMAT->read_line(\$LINES); $cpt++;
		if (keys(%$line0)) {
			while (my ($k, $v) = each (%$line0)) {
				die "$FORMAT, line $cpt: $k = $readLine{$k}, expected $$line0{$k}"
					unless $readLine{$k} eq $$line0{$k};
				$cpt2++;
			}
			print "Line $cpt OK: ", join(',', map { "$_=$readLine{$_}" } keys(%readLine)), "\n";
		} else {
			# Check that this line is empty, as it should be.
			die "Something in line $cpt" if %readLine;
			print "OK, line $cpt is empty as expected\n";
		}
	}
	
}

# -------------- Test line format ---------

my $LINES = << 'EOF';
test1|essai1|author1
test2|essai2|author2
EOF

&test(Silvestris::Cyclotis::Format->for_mime('text/plain'), $LINES, [
	{ src => 'test1', tra => 'essai1', author => 'author1' },
	{ src => 'test2', tra => 'essai2', author => 'author2' },
	{}
]);


# -------------- Test json format ---------

my $LINES = << 'EOF';
[
	{ "src": "test2.1", "tra": "essai2.1", "author" : "author2.1" },
	{ "src": "test2.2", "tra": "essai2.2", "author" : "author2.2" }
	
]
	
EOF

&test(Silvestris::Cyclotis::Format->for_mime('text/json'), $LINES, [
	{ src => "test2.1", tra => "essai2.1", author => "author2.1" },
	{ src => "test2.2", tra => "essai2.2", author => "author2.2" },
	{}
]);

# -------------- Test tmx ---------

my $LINES = << 'EOF';
<tmx>
	<body>
		<tu creationid="creation id in unit">
			<tuv>
				<seg>Source 3.1</seg>
			</tuv>
			<tuv>
				<seg>Translation 3.1</seg>
			</tuv>
		</tu>
		<tu >
			<tuv>
				<seg>Source 3.2</seg>
			</tuv>
			<tuv creationid="creation id in target">
				<seg>Translation 3.2</seg>
			</tuv>
		</tu>
	</body>
</tmx>
	
EOF

&test(Silvestris::Cyclotis::Format->for_mime('text/xml'), $LINES, [
	{ src => "Source 3.1", tra => "Translation 3.1", author => "creation id in unit" },
	{ src => "Source 3.2", tra => "Translation 3.2", author => "creation id in target" },
	{}
]);

