#! /usr/bin/env plackup

=head1 test-all.pl

This application is a sample implementation of authentication per URL.
It uses the same check methods than other applications, but it does not itself require authentication.
But do not use it with the same config file!!!

=cut

use Dancer;

use lib '../rest';
load '../rest/hooks/auth.pl';

get '/' => sub { "This application does not answer on /"; };

my $type = config->{'auth-db'}{'check-method'}{'type'} or die "No configured authentication";
print STDERR "Authentication method: $type\n";

=head1 GET /check?user=xxx&pass=yyy

Returns user group if correct, error message else.

=cut
get '/check' => sub {
  my $user = param('user'); my $pass = param('pass');
		my ($status, $message, $group);
		if (defined $Silvestris::Users::Cache{$user}) {
			if ($Silvestris::Users::Cache{$user}[0] ne $pass) {
				($status, $message, $group) = (401, 'Wrong user or password', undef); 
			} else {
				($status, $message, $group) = (0, undef, $Silvestris::Users::Cache{$user}[1]);       
			}
		} else {
			($status, $message, undef, $group) = &{$Silvestris::User::AuthMethod} ($user, $pass);
			$Silvestris::Users::Cache{$user} = [ $pass, $group ] unless $status >= 400 or $type =~ /file|config|rules/i; # keep in cache to avoid calling checkMethod
		}
  
  if ($status >= 400) {
    return "<error status='$status'>$message</error>";
  } else {
    return "<ok user='$user' group='$group' />";
  }
};

dance();

=head1 LICENSE

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
