#! /usr/bin/env plackup

=head1 test-url.pl

A small Dancer application to test that URL defined in the config file works.
It can also be used to check that the authentication rules also works.

=cut

use Dancer;

use lib '../rest';

set confdir => '../rest';

load 'hooks/auth.pl';

# Now let's emulate all Cyclotis commands, only to check authentication
use Silvestris::Dancer::MyRoutes;

sv_route 'contents.find' => get => '/tu/(:db/)?:table/:cmd(.:fmt)?' => sub {
	return sprintf ('User "%s" has access to contents.find for table %s/%s', (var 'auth_user'), param('db'), param('table'));
};
sv_route 'contents.save' => get => '/tu/(:db/)?:table' => sub {
	return sprintf ('User "%s" has access to contents.save for table %s/%s', (var 'auth_user'), param('db'), param('table'));
};
sv_route 'contents.delete' => get => '' => sub {
	return sprintf ('User "%s" has access to contents.delete for table %s/%s', (var 'auth_user'), param('db'), param('table'));
};
sv_route 'meta.info' => get => '/meta/((:db/)?:table/)?info(.:fmt)?' => sub {
	return sprintf ('User "%s" has access to meta.info for table %s/%s', (var 'auth_user'), param('db'), param('table'));
};
get '/' => sub {
	return 'User "%s" has access to /';
};


dance();

=head1 LICENSE

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
