#! /usr/bin/env perl

=encoding utf-8
=head1 DESCRIPTION

This script will merge contents of POD documentation from cyclotis-res-api.pl with Silvestris::... packages to produce a single POD.
If you defined URL inside config.yml, it will be used in replacement to the contents of Perl file.
Then you can convert to your favorite format using pod2...

=head1 USAGE

Without any parameter, the script will produce POD to STDOUT.

You can pipe it to pod2html, pod2pdf, ...

=cut

my %URL = ();
if (open (CONF, '<:encoding(utf-8)', 'config.yml')) { # Do not die on failure: This is not mandatory
	my $inUrl = 0;
	while (<CONF>) {
		$inUrl = 1 if /^url:/; $inUrl = 0 if /^[a-tv-z]/;
		$URL{find} = $1 if $inUrl and /^\s+find:\s*(.+)\r?\n/;
		$URL{save} = $1 if $inUrl and /^\s+save:\s*(.+)\r?\n/;
		$URL{info} = $1 if $inUrl and /^\s+info:\s*(.+)\r?\n/;
	}
	close (CONF);
}

open (MAIN, '<:encoding(utf-8)', 'cyclotis-rest-api.pl') or die "Cannot open cyclotis-rest-api.pl: $!";
my @LINES = <MAIN>; close (MAIN);

# Dump the header, until LICENSE. All will be inserted after this and before LICENSE.
my $inside = 0; my $line = undef;
while (defined ($line = shift (@LINES))) {
	if ($line =~ /LICENSE/) { unshift(@LINES,$line); last; }
	$inside = 1 if $line =~ /^\=/; $inside = 0 if $line =~ /^\=cut/;
	print $line if $inside;
}

# dump contents from routes/*.pl
opendir(RoutesDir, 'routes') or die "Cannot open routes dir : $!";
while (my $routesFile = readdir(RoutesDir)) {
	next unless $routesFile =~ /\.pl$/;
	open (RoutesFile, '<:encoding(utf-8)', "routes/$routesFile") or die "Cannot open $routesFile: $!";
	my @routesArray = <RoutesFile>; close (RoutesFile);
	print STDERR "Adding $routesFile\n";
	
	if ($routesFile =~ /contents/) {
		HEAD2:
		until ($line =~ /^=head2 POST/) {
			CUT:
			while (defined ($line = shift(@routesArray))) {
				if ($line =~ /^=head2 POST/) { unshift(@routesArray, $line); last HEAD2; }
				$inside = 1 if $line =~ /^\=/;
				$line =~ s/GET\s+(.+)\r?\n/GET $URL{find}\n/ if $URL{find} and ($line =~ /^=head2 GET/);
				print $line if $inside;
				if ($line =~ /^\=cut/) { $inside = 0; last CUT; }
			}
		}
		
		# Dump list of commands, which are now in Search.pm
		open (SEARCH, '<:encoding(utf-8)', 'Silvestris/Cyclotis/Database/Query/Search.pm') or die "Cannot open Search.pm: $!";
		$inside = 0;
		while (defined ($line = <SEARCH>)) {
			$inside = 1 if $line =~ /SEARCH MODES/; last if $inside and $line =~ /^=cut/; $line =~ s/head1/head3/;
			$line =~ s/^=line-item\s*([\w\,\(\)\|]+?):\t+(.+)$/=item *\n\nC<$1>: $2\n\n/; $line =~ s/^=line-item\s*\*\s+(.+)$/=item *\n\n$1\n\n/;
			print $line if $inside;
		}
		close (SEARCH);		
		
		# Dump contents of Formats, but converts headN to items 
		print "=head3 Available formats:\n\n";
		foreach my $class ('html', 'line', 'tmx', 'serial') {
			open (FMT, '<:encoding(utf-8)', "Silvestris/Cyclotis/Format/nodep/$class.pm") or die "Cannot open $class.pm: $!";
			my @FMT = <FMT>; close (FMT);

			while (($line = shift(@FMT)) !~ /LICENSE/) {
				$line =~ s/^\=head([3-9])\s+(.+)\r?\n$/I<$2>\n/;
				$line =~ s/^\=head([12])/"=head" . ($1 + 2)/e;
				$line =~ s/^\=item\s+(.+:)\s+(.+)$/=item *\n\n$1 $2\n/;
				$inside = 1 if $line =~ /^\=/ or $line =~ /^I</;
				$inside = 0 if $line =~ /^\=cut/;
				print $line if $inside;		
			}
			1 while shift(@FMT); # last lines are not used	
		}
		print "\n\n=over 1\n\n";
		foreach my $class ('perl', 'json', 'yaml') {
			print "=item *\n\n$class\n\n";
		}
		print "\n\n=back\n\n";
	}
	
	# other routes: insert as is.
	while (defined ($line = shift (@routesArray))) {
		last if $line =~ /LICENSE/;
		$inside = 1 if $line =~ /^\=/; $inside = 0 if $line =~ /^\=cut/; $inside = 0 if $line =~ /^\=head1/;
		$line =~ s/GET\s+(.+)\r?\n/GET $URL{info}\n/ if $URL{info} and ($line =~ /^=head2 GET/) and ($line =~ /info/);
		$line =~ s/^=item \-\s*(.+)$/=item *\n\n$1\n/;
		print $line if $inside;
	}
}
	
# Change copyright to current year
my $year = (localtime(time))[5] + 1900; s!Copyright\s(\d+)(\-\d+)?!Copyright 2013-$year! foreach @LINES;

# Now, dump the end of cyclotis-rest-api.pl
while (defined ($line = shift(@LINES))) {
	$inside = 1 if $line =~ /^\=/;
	$line =~ s/POST\s+(.+)\r?\n/POST $URL{save}\n/ if $URL{save} and ($line =~ /^=head2 POST/);
	$line =~ s/DELETE\s+(.+)\r?\n/DELETE $URL{delete}\n/ if $URL{delete} and ($line =~ /^=head2 DELETE/);
	print $line if $inside;
	if ($line =~ /^\=cut/) { $inside = 0; }
}



=head1 LICENSE

Copyright 2013-2016 Silvestris Project (L<http://www.silvestris-lab.org/>)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
