#! /usr/bin/env perl

=head1 DESCRIPTION

This HTTP application creates and deletes Cyclotis databases, and can list existing ones. 
This always answers in HTML format, to be used by a browser.

=head1 INSTALLATION REQUIREMENTS

This script does not replace SQL/db/dbcreator.pl, it is based on it: you must install it and put in the YAML configuration where it is.

If the configuration implies to create catalogs, it must be run on the same machine as the Postgres server.
Else, if all is in the same database, it is enough to call dbcreator.pl once on the Postgres machine, then everything works via DBI.

=cut

use Dancer;
use vr;
use DBI;

$ENV{CYCLOTIS_MODE} = config->{'SQL-scripts'}{mode} if config->{'SQL-scripts'}{mode}; 
push(@main::INC, config->{'SQL-scripts'}{dir});
eval "require $ENV{CYCLOTIS_MODE}::TableCreator;"; require DbCreator;

# 	----------------- Configuration -----------------

our $HTML_TEMPLATE; 
open (HTML, 'template.html') or die "Cannot open HTML template";
{ local $/ = undef; $HTML_TEMPLATE = <HTML>; $HTML_TEMPLATE =~ s/<!--.*?-->//gs; close HTML; }
our %TAL_Defines; 
while ($HTML_TEMPLATE =~ m!<(\w+)\s[^<>]*?tal:define-replace\s*=\s*([\"\'])(.+?)\2.*?>(.+?)</\1>!gs) { $TAL_Defines{$3} = $4; }
while ($HTML_TEMPLATE =~ m!<(\w+)\s[^<>]*?tal:define-fill\s*=\s*([\"\'])(.+?)\2.*?>(.+?)</\1>!gs) { $TAL_Defines{$3} = $&; $TAL_Defines{$3} =~ s!define-fill!fill!; }
while ($HTML_TEMPLATE =~ m!<(\w+)\s[^<>]*?tal:define-mark\s*=\s*([\"\'])(.+?)\2.*?>!gs) { $TAL_Defines{$3} = $&; $TAL_Defines{$3} =~ s!tal:define-mark\s*=\s*([\"\'])(.+?)\1!!;  }
$HTML_TEMPLATE =~ s!%HOSTNAME%!my $t = `hostname`; $t =~ s/[\s\n]//g; $t!e if $HTML_TEMPLATE =~ m!%HOSTNAME%!;

sub tal_replace (\$$$) {
	my $HTML = shift; my $item = shift; my $contents = shift; $contents = '' unless defined $contents;
	$$HTML =~ s{<(\w+)([^>]+)tal:replace\s*=\s*[\"\']?$item[\"\']?.*?</\1>}{$contents}s; 
	$$HTML =~ s{<(\w+)([^>]+)tal:fill\s*=\s*[\"\']?$item[\"\']?([^>]*)>(.*?)</\1>}{<$1$2$3>$contents</$1>}s; 
}

our %ALT_FIELDS = ();

sub form_from_params {
	my $formParams = shift or return '<!-- No form -->'; my $altFieldsLitId = shift;
	
	my $FIELDS = "";
PARAM:
	foreach my $f (@{$formParams}) {
		if (my $tab = $f->{alternatives}) {
			%ALT_FIELDS = ();
			$FIELDS .= "<table border=1><tr>";
			foreach my $item (@$tab) {
				$ALT_FIELDS{$item->{label}} = [];
				$FIELDS .= "<td><h3><input type=radio name=altfields value='$item->{label}' onchange=\"grayFields('$item->{label}')\">$item->{label}</h3>";
				$FIELDS .= &form_from_params($item->{fields}, $item->{label});	# ref to array
				$FIELDS .= "</td>";
			}
			$FIELDS .= "</tr></table>";
			$FIELDS .= << "EOF";
	<script type="text/javascript">
		function grayFields(label) {
EOF
			while (my ($id, $fieldsList) = each (%ALT_FIELDS)) {
				foreach my $field0 (@$fieldsList) {
					$FIELDS .= "			createForm.elements['$field0'].disabled = (label != '$id');\n"; 
				}
			}
			$FIELDS .= << "EOF";
		}
		
		grayFields('$tab->[0]{label}');	createForm.elements['altfields'].value = '$tab->[0]{label}';
	</script>
EOF
			next PARAM;
		}
		next PARAM unless $f->{type};
		if ($f->{type} eq 'text') {
			my $curField = $TAL_Defines{'sample-field-text'};
			$curField ||= '<x tal:replace="label">Label</x>: <input type=text tal:attr-name=xxx tal:attributes="here">';
			tal_replace($curField, label => $f->{label});
			$curField =~ s!\btal:attr-name\s*=\s*[\'\"]?\w+[\'\"]?!name=$f->{'var-name'}!;
			$curField =~ s{tal:attributes\s*=\s*([\'\"])?.+?\1}{
				my $att = '';
				$att .= "value='$f->{default}' " if $f->{default};
				while (my ($k,$v) = each (%{$f->{html}})) { $att .= " $k='$v' "; }				
				$att;
			}e;
			$FIELDS .= $curField;
		}
		if ($f->{type} eq 'select') {
			my $curField = $TAL_Defines{'sample-field-select'};
			$curField ||= '<x tal:replace="label">Label</x>: <select tal:attr-name=xxx></select>';
			tal_replace($curField, label => $f->{label});
			$curField =~ s!\btal:attr-name\s*=\s*[\'\"]?\w+[\'\"]?!name=$f->{'var-name'}!;
			my $opt = "";
			if ($f->{'allowed-empty'}) { $opt .= "<option value=''>$f->{'allowed-empty'}</option>"; }
			elsif ($f->{'default-empty'}) { $opt .= "<option value='' selected>$f->{'default-empty'}</option>"; }
			foreach my $v (@{config->{'possible-values'}{$f->{'var-name'}}}) {
				my $txt = $f->{'value-to-text'}{$v}; $txt ||= $v;
				if (defined $f->{default} and $v eq $f->{default}) { $opt .= "<option selected value='$v'>$txt</option>"; }
				else { $opt .= "<option value='$v'>$txt</option>"; }
			}
			$curField =~ s!(<select[^>]+>)(.+)</select>!$1$opt</select>!is;
			$FIELDS .= $curField;			
		}
		if ($f->{type} eq 'checkbox') {
			$FIELDS .= "<input name=$f->{'var-name'} type=checkbox $f->{default}> $f->{label}";
		}
		push (@{$ALT_FIELDS{$altFieldsLitId}}, $f->{'var-name'}) if $altFieldsLitId;
		$FIELDS .= $TAL_Defines{'field-separator'} ||= '';
	}
	return $FIELDS;
}
tal_replace($HTML_TEMPLATE, 'create-form' => form_from_params(config->{'creation-parameters'}));
tal_replace($HTML_TEMPLATE, 'filter-form' => form_from_params(config->{'filter-parameters'}));



# 	----------------- Database listing -----------------

sub toList {
	my $MEM = shift;
	if (ref($MEM) =~ /ARRAY/) { return @$MEM; }
	elsif (ref($MEM) =~ /HASH/) {
		my @V = ();
		while (my ($k, $v) = each (%$MEM)) { push(@V, toList($v)); }
		return @V;
	}
}

sub memoriesTable {
	my $HTML_TABLE = $TAL_Defines{'list-header-row'} ||= '<tr>';
	foreach my $col (@{config->{list}{table}}) {
		my $htmlCol = $TAL_Defines{'list-header-col'} ||= '<td tal:fill="list-header-col">sample</td>';
		tal_replace($htmlCol, 'list-header-col' => $col->{label});
		$HTML_TABLE .= $htmlCol;
	}
	$HTML_TABLE .= "</$1>" if $TAL_Defines{'list-header-row'} =~ /^\s*<(\w+)/;
	
	my $time = time(); if ($HTML_TEMPLATE =~ /query-duration/) { require Time::HiRes; $time = Time::HiRes::time(); }
  my %MEM = vr::memoriesList(); my $SPEC = shift || {}; $SPEC->{$_} ||= '' foreach ('host','port','catalog','table'); my $count = 0;
	foreach my $mem (toList(\%MEM)) {
		my $rowType = 'unselected'; $rowType = 'selected'
			if ($mem->{host} eq $SPEC->{host}) and ($mem->{port} eq $SPEC->{port})
			and ($mem->{catalog} eq $SPEC->{catalog}) and (lc($SPEC->{table}) eq lc("$mem->{table_schema}.$mem->{table_name}"));
		if ($mem->{error}) { $rowType = 'error'; next unless $TAL_Defines{"list-error-row"}; }
		elsif ($rowType eq 'unselected') {
			if ($TAL_Defines{"list-even-row"} and $TAL_Defines{"list-odd-row"}) {
				if ($count % 2 == 0) { $rowType = 'even'; } else { $rowType = 'odd'; }
			}
		}
		$HTML_TABLE .= $TAL_Defines{"list-$rowType-row"} ||= '<tr>';
		foreach my $col (@{config->{list}{table}}) {
			my $colType = $col->{'col-type'}; if ($colType) { $colType = "list-$rowType-col-$colType"; } else { $colType = "list-$rowType-col"; }
			my $htmlCol = $TAL_Defines{$colType} ||= '<td tal:fill="list-memory-col">sample</td>';
			$htmlCol =~ s/<td /<td align=$col->{'text-align'} / if $col->{'text-align'};
			tal_replace($htmlCol, $colType => $mem->{$col->{'var-name'}});		
			$HTML_TABLE .= $htmlCol;
		}
		my @params = vr::reverseDatabaseParams($mem); my $urlParams = ""; while (my $k = shift(@params)) { $urlParams .= $k . "=" . shift(@params) . '&'; }
		my $htmlCol = $TAL_Defines{"list-$rowType-trados"};
		$htmlCol =~ s/%LINK%/trados-params?$urlParams&parent=$mem->{std_parent}/;
		$HTML_TABLE .= $htmlCol;
		if ($htmlCol = $TAL_Defines{"list-$rowType-omegat"}) { 
			$htmlCol =~ s!%LINK%!"omegat-params?" . join('&', map { "$_=$mem->{$_}" } grep { $mem->{$_} } keys(%$mem))!e;
			$HTML_TABLE .= $htmlCol;
		}
		$htmlCol = $TAL_Defines{"list-$rowType-del"};
		$htmlCol =~ s/%LINK%/deletedb?$urlParams/;
		$HTML_TABLE .= $htmlCol;
		$HTML_TABLE .= "</$1>" if $TAL_Defines{"list-$rowType-row"} =~ /^\s*<(\w+)/;
 		$count++;
	}
	
	$time = Time::HiRes::time() - $time if $HTML_TEMPLATE =~ /query-duration/;
	return $HTML_TABLE . "<!--:count=$count--><!--:time=$time-->";
}


	
get '/' => \&list;
get '/list' => \&list;

sub list {
	my $HTML = $HTML_TEMPLATE; $HTML =~ s!</main>!! if $HTML =~ s!<main\s+tal:use="(no|replace)"\s*>!!;
	tal_replace($HTML, list => memoriesTable(shift));
	tal_replace($HTML, 'total-row-count' => $1) if $HTML =~ s{<!--:count=(\d+)-->}{};
	if ($HTML =~ s{<!--:time=([\d\.]+)-->}{}) { my $time = $1;   $HTML =~ s!\{query-duration\}!$time!; }

	if (my $err = var 'message') { tal_replace($HTML, message => "$err <br/><hr/><br/>"); }
	else { tal_replace($HTML, message => ''); }
	
  if (my %params = %{params()}) {
    $HTML .= '<script type="text/javascript">';
    foreach my $param0 (@{config->{'filter-parameters'}}) {
      if (defined $params{$param0->{'var-name'}}) {
        $HTML .= sprintf("\n   document.forms['filterForm'].elements['%s'].value = '%s';", $param0->{'var-name'}, $params{$param0->{'var-name'}});
      }
    }
    $HTML .= '</script>';
  }
   
	return $HTML;
};


# 	----------------- Database creation -----------------

get '/createdb' => sub {
	my %spec = vr::fillDatabaseParams();
  $spec{table} =~ tr/- /__/; # from user typing: forbidden separator characters replaced by _
	
	# Check that rules are respected. If not, do not even try to create tables
	foreach my $ruleSet (grep { $_->{rules} } @{config->{'creation-parameters'}}) {
		foreach my $rule (@{$ruleSet->{rules}}) {
			my $expr = $rule->{expression};
			unless ($expr) {
				my $var1 = vr::interpolation($rule->{var1}, \%spec); my $var2 = vr::interpolation($rule->{var2}, \%spec); 
				$expr = sprintf('"%s" %s "%s"', $var1, $rule->{rule}, $var2);
			}
			unless (eval $expr) {
				var message => "<font color=red>Error:</font> $rule->{message}";
				return &list(\%spec);
			}
		}
	}
	
	my $creator = bless { dbiSpec => sprintf('dbi:Pg:host=%s;port=%i;dbname=%s', @spec{'host','port','catalog'}) }, "$ENV{CYCLOTIS_MODE}::TableCreator";
	$creator->{dbh} = DBI->connect($creator->{dbiSpec}, $spec{user}, $spec{pass});
	$creator->loadTables(); eval { $creator->doCreate_table($spec{table}, $spec{parent}); };
	if (my $cause = $DBI::errstr || $@) { var message => "<font color=red>Error:</font> $cause"; } 
	else { var message => "Creation of <b>$spec{table}</b> <font color=green>OK</font>"; }
	if ($spec{'rule-field'}) {
		DbCreator::doCreate_rule($creator->{dbh}, $spec{table}, $spec{'rule-field'}, $spec{'rule-action'});
		if (my $cause = $DBI::errstr || $@) { var message => var('message') . " <br/> <font color=red>Error:</font> $cause"; } 
		else { var message => var('message') . " <br/> Creation of rule for <b>$spec{table}</b> <font color=green>OK</font>"; }
	}
	
	$creator->{dbh}->disconnect;      
	
	return &list(\%spec);
};

get '/deletedb' => sub {
	my %spec = vr::fillDatabaseParams();
	my $DBI = DBI->connect(sprintf('dbi:Pg:host=%s;port=%i;dbname=%s', @spec{'host','port','catalog'}, $spec{'user'}, $spec{'pass'}));
	$DBI->do ("drop table " . $spec{'table'} . " cascade");
	my ($schema, $table) = split(/\./, $spec{'table'}); ($schema, $table) = ('public', $spec{'table'}) unless $table;
	if (config->{list}{sql}{table} and not $DBI::errstr) {
		my ($infoTable, $infoSchemaCol, $infoTableCol) = (config->{list}{sql}{table}, 'table_schema', 'table_name');
		if (ref ($infoTable)) { 
			$infoSchemaCol &&= $infoTable->{fields}{'table-schema'}; $infoTableCol &&= $infoTable->{fields}{'table-name'};
			$infoTable = $infoTable->{name};
		}
		my ($schema, $table) = split(/\./, $spec{'table'}); ($schema, $table) = ('public', $spec{'table'}) unless $table;
		$DBI->do ("delete from $infoTable where lower($infoSchemaCol) = '\L$schema\E' and lower($infoTableCol) = '\L$table\E'\n")
	}
	if ($DBI::errstr) { var message => "<font color=red>ERROR</font>: $DBI::errstr" }
	else { var message => "Deletion of memory $spec{'table'} <font color=green>OK</font>"; }
	$DBI->disconnect;
	return &list();
};

# ---------------- Parameters for your application ---------------------

get '/trados-params' => sub {
	my %params = vr::fillDatabaseParams();
	if (my $proxy = config->{'http-proxy'}) {
		my $tableSpec = "<tr> <td>HTTP URL</td><td>$proxy?table=$params{table}</td> </tr>";
   my $tradosWindows = "<table border=0>
					<tr> <td colspan=6 bgcolor='#9090FF'>HTTP connection Options</td></tr>
					<tr bgcolor='#BBBBBB'> <td align=right>URL</td><td colspan=3 class=full><input type=text readonly size=100 value='$proxy?table=$params{table}'></td></tr>
					<tr bgcolor='#BBBBBB'> <td align=right>User</td><td><input type=text readonly value=''></td> <td align=right>Password</td><td><input type=text readonly value=''></td></tr>
     			</table>";   
		if (defined($params{parent}) and ($params{parent} =~ /^(\w+\.)?\w+$/)) {
			$tableSpec = "
				<tr> <td>HTTP URL (no inheritance)</td><td>$proxy?table=$params{table}&inherit=0</td> </tr>
				<tr> <td>HTTP URL (with inheritance)</td><td>$proxy?table=$params{table}&inherit=1</td> </tr>
			";
      $tradosWindows = "<table border=0><tr><td><h3>No inheritance</h3></td><td width=50></td><td><h3>With inheritance</h3></td></tr>
      <tr><td>\n$tradosWindows\n</td><td width=50></td><td>\n$tradosWindows\n</td></tr></table>";
      $tradosWindows =~ s/table=(.+)\'/$&\&inherit=0/; # first instance  (no /g flag!)
      $tradosWindows =~ s/table=(.+)\'/$&\&inherit=1/; # second instance  (no /g flag!)
		}
		my $HTML = $HTML_TEMPLATE; $HTML =~ s[<main.*</main>][	
    <h2>Technical data</h2>
    	
		 <table border=1>
			 $tableSpec
		 </table>  
      
      <h2>Trados windows</h2>
      
      $tradosWindows
		]s;
		tal_replace($HTML, message => '');
		return $HTML;
	} else {
		my $tableSpec = "<tr> <td>Table</td><td>$params{table}</td> </tr>";
   my $tradosWindows = "<table border=0>
					<tr> <td colspan=6 bgcolor='#9090FF'>Postgres Provider Options</td></tr>
					<tr bgcolor='#BBBBBB'> <td align=right>Host name</td><td><input type=text readonly value='$params{host}'></td> <td align=right>Port</td><td><input type=text readonly value='$params{port}'></td> </tr>
					<tr bgcolor='#BBBBBB'> <td align=right>Database</td><td><input type=text readonly value='$params{catalog}'></td> <td align=right>Table</td><td><input type=text readonly name=table value='$params{table}'></td></tr>
					<tr bgcolor='#BBBBBB'> <td align=right>User</td><td><input type=text readonly value=''></td> <td align=right>Password</td><td><input type=text readonly value=''></td></tr>
					</table>";
   
		if (defined($params{parent}) and ($params{parent} =~ /^(\w+\.)?\w+$/)) {
			$tableSpec = "
				<tr> <td>Table (no inheritance)</td><td>$params{table}</td> </tr>
				<tr> <td>Table (with inheritance)</td><td>$params{parent},$params{table}</td> </tr>
			";
      
      $tradosWindows = "<table border=0><tr><td><h3>No inheritance</h3></td><td width=50></td><td><h3>With inheritance</h3></td></tr>
      <tr><td>\n$tradosWindows\n</td><td width=50></td><td>\n$tradosWindows\n</td></tr></table>";
      $tradosWindows =~ s!name=table!!; # first instance (no /g flag!)
      $tradosWindows =~ s!name=table value='(.+)'!value='$params{parent},$params{table}'!; # second instance, not subsituted first time
		}
		my $HTML = $HTML_TEMPLATE; $HTML =~ s[<main.*</main>][
    <h2>Technical data</h2>
    	
		 <table border=1>
			 <tr> <td>Host</td><td>$params{host}</td> </tr>
			 <tr> <td>Port</td><td align=right>$params{port}</td> </tr>
			 <tr> <td>Database</td><td>$params{catalog}</td> </tr>
			 $tableSpec
		 </table>  
      
      <h2>Trados windows</h2>
      
      $tradosWindows
		]s;
		tal_replace($HTML, message => '');
		return $HTML;
	}
};

get '/omegat-params' => sub {
	my %params = params('query');	
	my $xmlServer = config->{'xml-server'}{'host'} . '/omegat?';
	if (ref (config->{'xml-server'}{'params'}{'omegat'}) =~ /ARRAY/) {
		foreach my $item (@{config->{'xml-server'}{'params'}{'omegat'}}) { $xmlServer .= "$item=" . $params{$item} . "&"; }
	} elsif (ref (config->{'xml-server'}{params}{'omegat'}) =~ /HASH/) {
		foreach my $item (keys %{config->{'xml-server'}{'params'}{'omegat'}}) { 
			$xmlServer .= "$item=" . vr::interpolation(config->{'xml-server'}{'params'}{'omegat'}{$item}, \%params) . "&"; 
		}
	}
	my $tableSpec = "<a href='$xmlServer!&attach=$params{projname}.properties'>Save to file</a>
		<iframe width='100%' src='$xmlServer!'></iframe> ";
	if ($params{std_parent} =~ /^(\w+\.)?\w+$/ or $params{real_parent} =~ /^(\w+\.)?\w+$/) {
		$tableSpec = "<table border=0><tr>
			<td><h2>No inheritance</h2> $tableSpec</td> <td width=20>&nbsp;</td> <td><h2>With inheritance</h2> $tableSpec</td>
			</tr></table>";
		$tableSpec =~ s/!/inherit=0&/; $tableSpec =~ s/!/inherit=0&/; # first href & iframe 
		$tableSpec =~ s/!/inherit=1&/; $tableSpec =~ s/!/inherit=1&/; # second href & iframe 
	}
	my $HTML = $HTML_TEMPLATE; $HTML =~ s[<main.*</main>][$tableSpec]s;
	tal_replace($HTML, message => '');
	return $HTML;
};

dance;

=head1 License

Copyright 2013-2016 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
